/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import snownee.jade.gui.config.OptionsList;

public class OptionButton
extends OptionsList.Entry {
    protected Component title;

    public OptionButton(String titleKey, Button button) {
        this((Component)OptionButton.makeTitle(titleKey), button);
    }

    public OptionButton(Component title, Button button) {
        this.title = title;
        this.addMessage(title.getString());
        if (button != null) {
            if (button.getMessage().getString().isEmpty()) {
                button.setMessage(title);
            } else {
                this.addMessage(button.getMessage().getString());
            }
            this.addWidget((AbstractWidget)button, 0);
        }
    }

    public OptionButton(Component title, Button.Builder builder) {
        this(title, builder.createNarration($ -> CommonComponents.joinForNarration((Component[])new Component[]{title, (Component)$.get()})).build());
    }

    @Override
    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        if (this.shouldRenderTitle()) {
            Font font = this.client.font;
            int n = this.getContentX() + 10;
            int n2 = this.getContentYMiddle();
            Objects.requireNonNull(this.client.font);
            guiGraphics.drawString(font, this.title, n, n2 - 9 / 2, -1);
        }
        super.renderContent(guiGraphics, mouseX, mouseY, hovered, deltaTime);
    }

    protected boolean shouldRenderTitle() {
        return true;
    }
}

