/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.JadeKeys;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.gui.config.BelowOrAboveListEntryTooltipPositioner;
import snownee.jade.gui.config.NotUglyEditBox;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.OptionsNav;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.overlay.DisplayHelper;

public abstract class BaseOptionsScreen
extends Screen {
    protected final @Nullable Screen parent;
    public @Nullable Button saveButton;
    protected @Nullable Runnable saver;
    protected @Nullable Runnable canceller;
    protected @Nullable OptionsList options;
    protected @Nullable OptionsNav optionsNav;
    private @Nullable NotUglyEditBox searchBox;

    public BaseOptionsScreen(@Nullable Screen parent, Component title) {
        super(title);
        this.parent = parent;
    }

    protected void init() {
        Objects.requireNonNull(this.minecraft);
        Objects.requireNonNull(this.saver);
        double scroll = this.options == null ? 0.0 : this.options.scrollAmount();
        super.init();
        if (this.options != null) {
            this.options.removed();
        }
        this.options = this.createOptions(new OptionsList(this, this.minecraft, 120, 0, this.width - 120, this.height - 32, 26, IWailaConfig.get()::save));
        this.options.setX(120);
        this.optionsNav = new OptionsNav(this.options, 120, this.height - 32 - 18, 18, 18);
        this.searchBox = new NotUglyEditBox(this, this.font, 0, 0, 120, 18, this.searchBox, (Component)Component.translatable((String)"gui.jade.search")){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public @Nullable ComponentPath nextFocusPath(FocusNavigationEvent event) {
                if (event instanceof FocusNavigationEvent.ArrowNavigation) {
                    ScreenDirection direction;
                    FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
                    try {
                        ScreenDirection screenDirection;
                        direction = screenDirection = arrowNavigation.direction();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (direction.getAxis() == ScreenAxis.HORIZONTAL) {
                        return null;
                    }
                }
                if (event instanceof FocusNavigationEvent.InitialFocus) {
                    return null;
                }
                return super.nextFocusPath(event);
            }
        };
        this.searchBox.setHint((Component)Component.translatable((String)"gui.jade.search.hint"));
        this.searchBox.setResponder(s -> {
            this.options.updateSearch((String)s);
            this.optionsNav.refresh();
        });
        this.searchBox.fixedTextX = 12;
        this.searchBox.fixedTextY = 6;
        this.searchBox.fixedInnerWidth = this.searchBox.getWidth() - 12 - 18;
        Identifier searchBoxBackground = JadeIds.JADE("search_box_background");
        this.searchBox.background = new WidgetSprites(searchBoxBackground, searchBoxBackground);
        this.searchBox.alwaysRenderCross = true;
        this.searchBox.updateTextPosition();
        this.addRenderableWidget((GuiEventListener)this.optionsNav);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.addRenderableWidget((GuiEventListener)this.options);
        this.options.updateSearch(this.searchBox.getValue());
        this.optionsNav.refresh();
        this.options.forceSetScrollAmount(scroll);
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.jade.save_and_quit").withStyle(style -> style.withColor(-4589878)), w -> {
            OptionValue<?> invalidEntry = this.options().invalidEntry;
            if (invalidEntry == null) {
                this.options().save();
                this.saver.run();
                this.minecraft.setScreen(this.parent);
            } else {
                this.changeFocus(ComponentPath.path((GuiEventListener)((GuiEventListener)Objects.requireNonNull(invalidEntry.getFirstWidget())), (ContainerEventHandler[])new ContainerEventHandler[]{invalidEntry, this.options(), this}));
                this.options().scrollToEntry(invalidEntry);
            }
        }).bounds(this.width - 100, this.height - 25, 90, 20).build());
        if (this.canceller != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, w -> this.onClose()).bounds(this.saveButton.getX() - 95, this.height - 25, 90, 20).build());
        }
        this.options.updateSaveState();
    }

    public OptionsList options() {
        return Objects.requireNonNull(this.options);
    }

    public OptionsNav optionsNav() {
        return Objects.requireNonNull(this.optionsNav);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        OptionsList.Entry entry;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        OptionsList.Entry entry2 = entry = this.options().isMouseOver(mouseX, mouseY) ? this.options().getEntryAt(mouseX, mouseY) : null;
        if (entry != null) {
            int valueX = entry.getTextX();
            if (mouseX >= valueX && mouseX < valueX + entry.getTextWidth()) {
                ArrayList descs = Lists.newArrayListWithExpectedSize((int)3);
                descs.addAll(entry.getDescription());
                if (JadeUI.hasShiftDown()) {
                    descs.addAll(entry.getDescriptionOnShift());
                }
                if (!descs.isEmpty()) {
                    descs.replaceAll(BaseOptionsScreen::processBuiltInVariables);
                    this.setTooltipForNextFrame(guiGraphics, descs, mouseX, mouseY, entry);
                }
            }
            if (entry instanceof OptionValue) {
                OptionValue optionValue = (OptionValue)entry;
                if (optionValue.serverFeature) {
                    int x = entry.getTextX() + entry.getTextWidth() + 1;
                    int y = entry.getContentY() + 6;
                    if (mouseX >= x && mouseX < x + 4 && mouseY >= y && mouseY < y + 4) {
                        this.setTooltipForNextFrame(guiGraphics, List.of(Component.translatable((String)"gui.jade.server_feature")), mouseX, mouseY, entry);
                    }
                }
            }
        }
    }

    public void setTooltipForNextFrame(GuiGraphics guiGraphics, List<Component> descs, int mouseX, int mouseY, OptionsList.Entry entry) {
        Font font = DisplayHelper.font();
        List list = descs.stream().flatMap($ -> font.split((FormattedText)$, 255).stream()).toList();
        guiGraphics.setTooltipForNextFrame(font, list, (ClientTooltipPositioner)new BelowOrAboveListEntryTooltipPositioner(this.options(), entry), mouseX, mouseY, false);
    }

    public static Component processBuiltInVariables(Component component) {
        MutableComponent keyName;
        ArrayList objects;
        if (component.getString().contains("${SHOW_DETAILS}")) {
            objects = Lists.newArrayListWithExpectedSize((int)3);
            objects.add(Component.translatable((String)"key.jade.show_details"));
            if (!JadeKeys.showDetails().isUnbound()) {
                objects.add(JadeKeys.showDetails().getTranslatedKeyMessage().copy().withStyle(ChatFormatting.AQUA));
            }
            keyName = Component.translatable((String)("config.jade.key_name_n_bind_" + (objects.size() - 1)), (Object[])objects.toArray());
            component = BaseOptionsScreen.replaceVariables(component, "${SHOW_DETAILS}", (Component)keyName);
        }
        if (component.getString().contains("${SHOW_OVERLAY}")) {
            objects = Lists.newArrayListWithExpectedSize((int)3);
            objects.add(Component.translatable((String)JadeKeys.showOverlay().getName()));
            if (!JadeKeys.showOverlay().isUnbound()) {
                objects.add(JadeKeys.showOverlay().getTranslatedKeyMessage().copy().withStyle(ChatFormatting.AQUA));
            }
            keyName = Component.translatable((String)("config.jade.key_name_n_bind_" + (objects.size() - 1)), (Object[])objects.toArray());
            component = BaseOptionsScreen.replaceVariables(component, "${SHOW_OVERLAY}", (Component)keyName);
        }
        return component;
    }

    private static Component replaceVariables(Component component, String source, Component replacement) {
        MutableComponent newComponent = Component.empty().withStyle(component.getStyle());
        for (Component part : component.toFlatList()) {
            String partString = part.getString();
            if (partString.contains(source)) {
                boolean first = true;
                for (String s : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)partString, (String)source)) {
                    if (first) {
                        first = false;
                    } else {
                        newComponent.append(replacement);
                    }
                    if (s.isEmpty()) continue;
                    newComponent.append((Component)Component.literal((String)s));
                }
                continue;
            }
            newComponent.append(part);
        }
        return newComponent;
    }

    public abstract OptionsList createOptions(OptionsList var1);

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.optionsNav().isMouseOver(mouseX, mouseY)) {
            return this.optionsNav().mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        return this.options().mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public void onClose() {
        if (this.canceller != null) {
            this.canceller.run();
        }
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    public void removed() {
        this.options().removed();
    }

    public boolean shouldCloseOnEsc() {
        return this.options().selectedKey == null;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        int key = keyEvent.key();
        if (keyEvent.modifiers() == 0 && !(BaseOptionsScreen.deepGetFocused(this.getCurrentFocusPath()) instanceof EditBox) && (key >= 48 && key <= 90 || key >= 320 && key <= 329)) {
            this.setFocused((GuiEventListener)this.searchBox);
        } else if (key == 70 && keyEvent.hasControlDownWithQuirk() && !keyEvent.hasShiftDown() && !keyEvent.hasAltDown()) {
            this.setFocused((GuiEventListener)this.searchBox);
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public static @Nullable GuiEventListener deepGetFocused(@Nullable ComponentPath path) {
        if (path == null) {
            return null;
        }
        if (path instanceof ComponentPath.Path) {
            ComponentPath.Path node = (ComponentPath.Path)path;
            return BaseOptionsScreen.deepGetFocused(node.childPath());
        }
        return path.component();
    }
}

