/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.debug;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public class BlockPropertiesProvider
implements IBlockComponentProvider {
    public static final BlockPropertiesProvider INSTANCE = new BlockPropertiesProvider();

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        int burnOdds;
        int igniteOdds;
        BlockBehaviour.Properties properties = accessor.getBlock().properties();
        IThemeHelper themes = IThemeHelper.get();
        tooltip.add((Component)Component.translatable((String)"jade.block_destroy_time", (Object[])new Object[]{themes.info(Float.valueOf(properties.destroyTime))}));
        tooltip.add((Component)Component.translatable((String)"jade.block_explosion_resistance", (Object[])new Object[]{themes.info(Float.valueOf(properties.explosionResistance))}));
        if (properties.jumpFactor != 1.0f) {
            tooltip.add((Component)Component.translatable((String)"jade.block_jump_factor", (Object[])new Object[]{themes.info(Float.valueOf(properties.jumpFactor))}));
        }
        if (properties.speedFactor != 1.0f) {
            tooltip.add((Component)Component.translatable((String)"jade.block_speed_factor", (Object[])new Object[]{themes.info(Float.valueOf(properties.speedFactor))}));
        }
        if ((igniteOdds = ((FireBlock)Blocks.FIRE).getIgniteOdds(accessor.getBlockState())) != 0) {
            tooltip.add((Component)Component.translatable((String)"jade.block_ignite_odds", (Object[])new Object[]{themes.info(igniteOdds)}));
        }
        if ((burnOdds = ((FireBlock)Blocks.FIRE).getBurnOdds(accessor.getBlockState())) != 0) {
            tooltip.add((Component)Component.translatable((String)"jade.block_burn_odds", (Object[])new Object[]{themes.info(burnOdds)}));
        }
    }

    @Override
    public Identifier getUid() {
        return JadeIds.DEBUG_BLOCK_PROPERTIES;
    }

    @Override
    public boolean enabledByDefault() {
        return false;
    }
}

