/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.EitherHolder;
import org.jspecify.annotations.Nullable;
import snownee.jade.mixin.EntityAccess;
import snownee.jade.util.CommonProxy;

public final class EntityVariantHelper {
    private static final Object2BooleanMap<DataComponentType<?>> isVariantType = new Object2BooleanOpenHashMap();
    private static final Set<DataComponentType<?>> isColorType = Sets.newHashSet();
    private static final Map<EntityType<?>, @Nullable DataComponentType<?>> variantTypeByEntity = Maps.newHashMap();

    public static synchronized void addVariantMapping(EntityType<?> entityType, @Nullable DataComponentType<?> variantType) {
        variantTypeByEntity.put(entityType, variantType);
        if (variantType != null && !isVariantType.containsKey(variantType)) {
            EntityVariantHelper.addVariantType(variantType, true);
        }
    }

    public static synchronized void addVariantType(DataComponentType<?> type, boolean isVariant) {
        boolean isColor;
        Identifier key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(type);
        if (key == null) {
            isVariant = false;
        }
        isVariantType.put(type, isVariant);
        boolean bl = isColor = key != null && key.getPath().endsWith("/color");
        if (isColor) {
            isColorType.add(type);
        }
    }

    public static synchronized @Nullable DataComponentType<?> getVariantType(Entity entity) {
        EntityType entityType = entity.getType();
        if (variantTypeByEntity.containsKey(entityType)) {
            return variantTypeByEntity.get(entityType);
        }
        for (DataComponentType<?> type : EntityVariantHelper.componentTypes(entity)) {
            if (!EntityVariantHelper.isVariantType(type)) continue;
            variantTypeByEntity.put(entityType, type);
            return type;
        }
        return null;
    }

    public static synchronized @Nullable Object getVariant(Entity entity, boolean isColor) {
        DataComponentType<?> type = EntityVariantHelper.getVariantType(entity);
        if (type == null || isColorType.contains(type) != isColor) {
            return null;
        }
        return entity.get(type);
    }

    public static synchronized @Nullable Either<String, Component> getVariantName(Entity entity, boolean isColor) {
        Object variant;
        Object object = variant = EntityVariantHelper.getVariant(entity, isColor);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Holder.class, EitherHolder.class}, (Object)object, n)) {
            case -1: {
                return null;
            }
            case 0: {
                Holder holder = (Holder)object;
                Identifier id = holder.unwrapKey().map(ResourceKey::identifier).orElse(null);
                variant = id != null ? id : holder.value();
                break;
            }
            case 1: {
                EitherHolder holder = (EitherHolder)object;
                variant = holder.key().map(ResourceKey::identifier).orElse(null);
                break;
            }
        }
        String name = null;
        Either<String, Component> result = CommonProxy.getTranslatableName(variant);
        if (result != null) {
            return result;
        }
        if (variant instanceof Identifier) {
            Identifier id = (Identifier)variant;
            name = id.toShortLanguageKey();
        } else if (variant instanceof String) {
            name = variant.toString();
        } else if (variant instanceof StringRepresentable) {
            StringRepresentable stringRepresentable = (StringRepresentable)variant;
            name = stringRepresentable.getSerializedName();
        } else if (variant instanceof Enum) {
            Enum enumValue = (Enum)variant;
            name = enumValue.name();
        }
        return name == null ? null : Either.left((Object)name.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isVariantType(DataComponentType<?> type) {
        if (isVariantType.containsKey(type)) {
            return isVariantType.getBoolean(type);
        }
        Identifier key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(type);
        if (key == null) {
            EntityVariantHelper.addVariantType(type, false);
            return false;
        }
        String name = key.getPath();
        boolean result = name.endsWith("/variant") || key.getPath().endsWith("/color");
        EntityVariantHelper.addVariantType(type, result);
        return result;
    }

    private static List<DataComponentType<?>> componentTypes(Entity entity) {
        final ArrayList types = Lists.newArrayList();
        ((EntityAccess)entity).callApplyImplicitComponents(new DataComponentGetter(){

            public <T> @Nullable T get(DataComponentType<? extends T> dataComponentType) {
                types.add(dataComponentType);
                return null;
            }
        });
        return types;
    }
}

