/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.impl.common.sailing.warden;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ZoneIdentifier {
    private static final String ZONE_IDENTIFIER = ":Zone.Identifier";
    private static final String REFERRER_URL = "ReferrerUrl=";
    private static final String HOST_URL = "HostUrl=";
    private final String host;
    private final String referrer;

    private ZoneIdentifier(String host, String referrer) {
        this.host = host;
        this.referrer = referrer;
    }

    public static ZoneIdentifier of(File file) {
        File zoneFile = new File(file.getAbsolutePath() + ZONE_IDENTIFIER);
        if (zoneFile.exists()) {
            ZoneIdentifier zoneIdentifier;
            BufferedReader reader = new BufferedReader(new FileReader(zoneFile));
            try {
                String line;
                String host = null;
                String referrer = null;
                while ((line = reader.readLine()) != null && (referrer == null || host == null)) {
                    if (line.startsWith(REFERRER_URL)) {
                        referrer = ZoneIdentifier.stripInfo(line.substring(REFERRER_URL.length()));
                        continue;
                    }
                    if (!line.startsWith(HOST_URL)) continue;
                    host = ZoneIdentifier.stripInfo(line.substring(HOST_URL.length()));
                }
                zoneIdentifier = new ZoneIdentifier(host, referrer);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return zoneIdentifier;
        }
        return null;
    }

    private static String stripInfo(String urlString) {
        int endIdx;
        int startIdx = urlString.indexOf("://");
        if (startIdx != -1 && (endIdx = urlString.indexOf(47, startIdx += 3)) != -1) {
            return urlString.substring(startIdx, endIdx);
        }
        return urlString;
    }

    public String getHost() {
        return this.host;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public String toString() {
        return "ZoneIdentifier{host='" + this.host + "', referrer='" + this.referrer + "'}";
    }
}

