/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncPacket(boolean canTeleport, List<Identifier> allowedBiomes, ListMultimap<Identifier, Identifier> dimensionKeysForAllowedBiomeKeys) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncPacket> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"naturescompass", (String)"sync"));
    public static final StreamCodec<FriendlyByteBuf, SyncPacket> CODEC = StreamCodec.ofMember(SyncPacket::write, SyncPacket::read);

    public static SyncPacket read(FriendlyByteBuf buf) {
        boolean canTeleport = buf.readBoolean();
        ArrayList<Identifier> allowedBiomes = new ArrayList<Identifier>();
        ArrayListMultimap dimensionKeysForAllowedBiomeKeys = ArrayListMultimap.create();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Identifier biomeKey = buf.readIdentifier();
            int numDimensions = buf.readInt();
            ArrayList<Identifier> dimensionKeys = new ArrayList<Identifier>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensionKeys.add(buf.readIdentifier());
            }
            if (biomeKey == null) continue;
            allowedBiomes.add(biomeKey);
            dimensionKeysForAllowedBiomeKeys.putAll((Object)biomeKey, dimensionKeys);
        }
        return new SyncPacket(canTeleport, allowedBiomes, (ListMultimap<Identifier, Identifier>)dimensionKeysForAllowedBiomeKeys);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedBiomes.size());
        for (Identifier biomeKey : this.allowedBiomes) {
            buf.writeIdentifier(biomeKey);
            List dimensionKeys = this.dimensionKeysForAllowedBiomeKeys.get((Object)biomeKey);
            buf.writeInt(dimensionKeys.size());
            for (Identifier dimensionKey : dimensionKeys) {
                buf.writeIdentifier(dimensionKey);
            }
        }
    }

    public static void handle(SyncPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                NaturesCompass.canTeleport = packet.canTeleport;
                NaturesCompass.allowedBiomes = packet.allowedBiomes;
                NaturesCompass.dimensionKeysForAllowedBiomeKeys = packet.dimensionKeysForAllowedBiomeKeys;
            });
        }
    }

    public CustomPacketPayload.Type<SyncPacket> type() {
        return TYPE;
    }
}

