/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.items;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.gui.GuiWrapper;
import com.chaosthedude.naturescompass.network.SyncPacket;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import com.chaosthedude.naturescompass.util.ItemUtils;
import com.chaosthedude.naturescompass.util.PlayerUtils;
import com.chaosthedude.naturescompass.worker.BiomeSearchWorker;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.network.PacketDistributor;

public class NaturesCompassItem
extends Item {
    public static final String NAME = "naturescompass";
    public static final ResourceKey<Item> KEY = ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (Identifier)Identifier.fromNamespaceAndPath((String)"naturescompass", (String)"naturescompass"));
    private BiomeSearchWorker worker;

    public NaturesCompassItem() {
        super(new Item.Properties().setId(KEY).stacksTo(1));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (!player.isCrouching()) {
            if (level.isClientSide()) {
                ItemStack stack = ItemUtils.getHeldNatureCompass(player);
                GuiWrapper.openGUI(level, player, stack);
            } else {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean canTeleport = (Boolean)ConfigHandler.GENERAL.allowTeleport.get() != false && PlayerUtils.canTeleport(serverPlayer.level().getServer(), player);
                List<Identifier> allowedBiomeKeys = BiomeUtils.getAllowedBiomeKeys(level);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPacket(canTeleport, allowedBiomeKeys, BiomeUtils.getGeneratingDimensionsForAllowedBiomes(serverLevel)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            if (this.worker != null) {
                this.worker.stop();
                this.worker = null;
            }
            this.setState(player.getItemInHand(hand), null, CompassState.INACTIVE, player);
        }
        return InteractionResult.CONSUME;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (this.getState(oldStack) == this.getState(newStack)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void searchForBiome(ServerLevel level, Player player, Identifier biomeKey, BlockPos pos, ItemStack stack) {
        this.setSearching(stack, biomeKey, player);
        Optional<Biome> optionalBiome = BiomeUtils.getBiomeForKey((Level)level, biomeKey);
        if (optionalBiome.isPresent()) {
            if (this.worker != null) {
                this.worker.stop();
            }
            this.worker = new BiomeSearchWorker(level, player, stack, optionalBiome.get(), pos);
            this.worker.start();
        }
    }

    public void succeed(ItemStack stack, Player player, int x, int z, int samples, boolean displayCoordinates) {
        this.setFound(stack, x, z, samples, player);
        this.setDisplayCoordinates(stack, displayCoordinates);
        this.worker = null;
    }

    public void fail(ItemStack stack, Player player, int radius, int samples) {
        this.setNotFound(stack, player, radius, samples);
        this.worker = null;
    }

    public boolean isActive(ItemStack stack) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            return this.getState(stack) != CompassState.INACTIVE;
        }
        return false;
    }

    public void setSearching(ItemStack stack, Identifier biomeKey, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.BIOME_ID, (Object)biomeKey.toString());
            stack.set(NaturesCompass.COMPASS_STATE, (Object)CompassState.SEARCHING.getID());
        }
    }

    public void setFound(ItemStack stack, int x, int z, int samples, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.COMPASS_STATE, (Object)CompassState.FOUND.getID());
            stack.set(NaturesCompass.FOUND_X, (Object)x);
            stack.set(NaturesCompass.FOUND_Z, (Object)z);
            stack.set(NaturesCompass.SAMPLES, (Object)samples);
        }
    }

    public void setNotFound(ItemStack stack, Player player, int searchRadius, int samples) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.COMPASS_STATE, (Object)CompassState.NOT_FOUND.getID());
            stack.set(NaturesCompass.SEARCH_RADIUS, (Object)searchRadius);
            stack.set(NaturesCompass.SAMPLES, (Object)samples);
        }
    }

    public void setInactive(ItemStack stack, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.COMPASS_STATE, (Object)CompassState.INACTIVE.getID());
        }
    }

    public void setState(ItemStack stack, BlockPos pos, CompassState state, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.COMPASS_STATE, (Object)state.getID());
        }
    }

    public void setFoundBiomeX(ItemStack stack, int x, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.FOUND_X, (Object)x);
        }
    }

    public void setFoundBiomeZ(ItemStack stack, int z, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.FOUND_Z, (Object)z);
        }
    }

    public void setBiomeKey(ItemStack stack, Identifier biomeKey, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.BIOME_ID, (Object)biomeKey.toString());
        }
    }

    public void setSearchRadius(ItemStack stack, int searchRadius, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.SEARCH_RADIUS, (Object)searchRadius);
        }
    }

    public void setSamples(ItemStack stack, int samples, Player player) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.SAMPLES, (Object)samples);
        }
    }

    public CompassState getState(ItemStack stack) {
        if (stack.getItem() == NaturesCompass.naturesCompass && stack.has(NaturesCompass.COMPASS_STATE)) {
            return CompassState.fromID((Integer)stack.get(NaturesCompass.COMPASS_STATE));
        }
        return null;
    }

    public void setDisplayCoordinates(ItemStack stack, boolean displayPosition) {
        if (stack.getItem() == NaturesCompass.naturesCompass) {
            stack.set(NaturesCompass.DISPLAY_COORDS, (Object)displayPosition);
        }
    }

    public int getFoundBiomeX(ItemStack stack) {
        if (stack.getItem() == NaturesCompass.naturesCompass && stack.has(NaturesCompass.FOUND_X)) {
            return (Integer)stack.get(NaturesCompass.FOUND_X);
        }
        return 0;
    }

    public int getFoundBiomeZ(ItemStack stack) {
        if (stack.getItem() == NaturesCompass.naturesCompass && stack.has(NaturesCompass.FOUND_Z)) {
            return (Integer)stack.get(NaturesCompass.FOUND_Z);
        }
        return 0;
    }

    public Identifier getBiomeKey(ItemStack stack) {
        if (stack.getItem() == NaturesCompass.naturesCompass && stack.has(NaturesCompass.BIOME_ID)) {
            return Identifier.parse((String)((String)stack.get(NaturesCompass.BIOME_ID)));
        }
        return Identifier.fromNamespaceAndPath((String)"", (String)"");
    }

    public int getSearchRadius(ItemStack stack) {
        if (stack.getItem() == NaturesCompass.naturesCompass && stack.has(NaturesCompass.SEARCH_RADIUS)) {
            return (Integer)stack.get(NaturesCompass.SEARCH_RADIUS);
        }
        return -1;
    }

    public int getSamples(ItemStack stack) {
        if (stack.getItem() == NaturesCompass.naturesCompass && stack.has(NaturesCompass.SAMPLES)) {
            return (Integer)stack.get(NaturesCompass.SAMPLES);
        }
        return -1;
    }

    public int getDistanceToBiome(Player player, ItemStack stack) {
        return BiomeUtils.getDistanceToBiome(player, this.getFoundBiomeX(stack), this.getFoundBiomeZ(stack));
    }

    public boolean shouldDisplayCoordinates(ItemStack stack) {
        if (stack.getItem() == NaturesCompass.naturesCompass && stack.has(NaturesCompass.DISPLAY_COORDS)) {
            return (Boolean)stack.get(NaturesCompass.DISPLAY_COORDS);
        }
        return true;
    }
}

