/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.supermartijn642.core.ClientUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;

public class ScreenItemRender {
    private static final ItemStackRenderState ITEM_STACK_RENDER_STATE = new ItemStackRenderState();
    private static FeatureRenderDispatcher featureRenderDispatcher;

    public static void drawItem(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, Item item, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        scale /= Math.sqrt(2.00390625);
        poseStack.pushPose();
        poseStack.translate(x, y, 0.0);
        poseStack.scale((float)(scale *= 1.6), (float)(-scale), (float)scale);
        ScreenItemRender.setupFeatureRenderer(bufferSource);
        ClientUtils.getMinecraft().getItemModelResolver().updateForTopItem(ITEM_STACK_RENDER_STATE, item.getDefaultInstance(), ItemDisplayContext.GUI, null, (ItemOwner)ClientUtils.getPlayer(), 0);
        ITEM_STACK_RENDER_STATE.submit(poseStack, (SubmitNodeCollector)featureRenderDispatcher.getSubmitNodeStorage(), 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
        featureRenderDispatcher.renderAllFeatures();
        poseStack.popPose();
    }

    private static void setupFeatureRenderer(MultiBufferSource.BufferSource bufferSource) {
        if (featureRenderDispatcher == null) {
            featureRenderDispatcher = new FeatureRenderDispatcher(new SubmitNodeStorage(), ClientUtils.getBlockRenderer(), bufferSource, ClientUtils.getMinecraft().getAtlasManager(), new OutlineBufferSource(){

                public VertexConsumer getBuffer(RenderType renderType) {
                    return VertexMultiConsumer.create((VertexConsumer[])new VertexConsumer[0]);
                }
            }, MultiBufferSource.immediate((ByteBufferBuilder)ByteBufferBuilder.exactlySized((int)0)), ClientUtils.getFontRenderer());
        } else {
            ScreenItemRender.featureRenderDispatcher.bufferSource = bufferSource;
        }
    }
}

