/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class PreviewModeButtonWidget
extends AbstractButtonWidget {
    public static final Identifier GREY_BUTTONS = Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/grey_buttons");
    public static final Identifier[][] ICONS = new Identifier[][]{{Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/icon_1x1"), Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/icon_1x1_grey")}, {Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/icon_3x1"), Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/icon_3x1_grey")}, {Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/icon_3x3"), Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/icon_3x3_grey")}};
    private final int mode;
    private final Supplier<Integer> currentMode;
    private final Supplier<Boolean> enabled;

    public PreviewModeButtonWidget(int x, int y, int width, int height, int mode, Supplier<Integer> currentMode, Supplier<Boolean> enabled, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.mode = mode;
        this.currentMode = currentMode;
        this.enabled = enabled;
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)"rechiseled.chiseling.preview").get();
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        int currentMode = this.currentMode.get();
        boolean selected = this.mode == currentMode;
        boolean enabled = this.enabled.get();
        graphics.submitSprite(GREY_BUTTONS, (float)this.x, (float)this.y, (float)this.width, (float)this.height, p -> p.uv(0.0f, (float)(!enabled || selected ? 1 : (this.isFocused() ? 2 : 0)) / 3.0f, 1.0f, 0.33333334f));
        graphics.submitSprite(ICONS[this.mode][selected ? 1 : 0], (float)(this.x + 1), (float)(this.y + 2), (float)(this.width - 2), (float)(this.height - 4));
    }
}

