/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.screen.ScreenItemRender;
import java.util.function.Supplier;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;

public class EntryButtonWidget
extends BaseWidget {
    public static final Identifier TEXTURE = Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/buttons");
    private final Supplier<ChiselingEntry> entry;
    private final Supplier<ChiselingEntry> selectedEntry;
    private final Runnable onClick;
    private final Supplier<Boolean> connecting;

    public EntryButtonWidget(int x, int y, int width, int height, Supplier<ChiselingEntry> entrySupplier, Supplier<ChiselingEntry> selectedEntrySupplier, Runnable onClick, Supplier<Boolean> connecting) {
        super(x, y, width, height);
        this.entry = entrySupplier;
        this.selectedEntry = selectedEntrySupplier;
        this.onClick = onClick;
        this.connecting = connecting;
    }

    public Component getNarrationMessage() {
        ChiselingEntry entry = this.entry.get();
        if (entry == null) {
            return null;
        }
        Item item = this.connecting.get() != false && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        return TextComponents.translation((String)"rechiseled.chiseling.select_block", (Object[])new Object[]{TextComponents.item((Item)item).get()}).get();
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        boolean selected;
        ChiselingEntry entry = this.entry.get();
        boolean hasEntry = entry != null;
        boolean bl = selected = hasEntry && this.selectedEntry.get() == entry;
        boolean hasCorrectItem = hasEntry && (this.connecting.get() != false ? entry.hasConnectingItem() : entry.hasRegularItem());
        graphics.submitSprite(TEXTURE, (float)this.x, (float)this.y, (float)this.width, (float)this.height, p -> p.uv(0.0f, (float)(selected ? 1 : (hasEntry ? (hasCorrectItem ? (this.isFocused() ? 2 : 0) : (this.isFocused() ? 4 : 3)) : 0)) / 5.0f, 1.0f, 0.2f));
    }

    public void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        ChiselingEntry entry = this.entry.get();
        if (entry != null) {
            Item item = this.connecting.get() != false && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
            graphics.submitCustomRendering(this.x, this.y, this.width, this.height, (poseStack, bufferSource) -> ScreenItemRender.drawItem(poseStack, bufferSource, item, (double)this.width / 2.0, (double)this.height / 2.0, this.width - 4, 0.0f, 0.0f, false));
        }
    }

    public boolean mousePressed(int mouseX, int mouseY, MouseButtonInfo info, boolean isDoubleClick, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            ChiselingEntry entry = this.entry.get();
            if (entry != null) {
                this.onClick.run();
            }
            return true;
        }
        return super.mousePressed(mouseX, mouseY, info, isDoubleClick, hasBeenHandled);
    }
}

