/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class ConnectingToggleWidget
extends AbstractButtonWidget {
    public static final Identifier GREY_BUTTONS = Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/grey_buttons");
    public static final Identifier ICON_CONNECTED_ON = Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/icon_connecting_true");
    public static final Identifier ICON_CONNECTED_OFF = Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/icon_connecting_false");
    private final Supplier<Boolean> connecting;
    private final Supplier<ChiselingEntry> currentEntry;

    public ConnectingToggleWidget(int x, int y, int width, int height, Supplier<Boolean> connecting, Supplier<ChiselingEntry> currentEntry, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.connecting = connecting;
        this.currentEntry = currentEntry;
    }

    public Component getNarrationMessage() {
        Holder message = new Holder();
        this.getTooltips(arg_0 -> ((Holder)message).set(arg_0));
        return (Component)message.get();
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        boolean connecting = this.connecting.get();
        ChiselingEntry currentEntry = this.currentEntry.get();
        if (currentEntry != null && (connecting ? currentEntry.hasRegularItem() : currentEntry.hasConnectingItem())) {
            tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.connecting", (Object[])new Object[]{TextComponents.translation((String)("rechiseled.chiseling.connecting." + (connecting ? "on" : "off"))).color(ChatFormatting.GOLD).get()}).get());
        }
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        boolean connecting = this.connecting.get();
        ChiselingEntry currentEntry = this.currentEntry.get();
        boolean canSwitch = currentEntry != null && (connecting ? currentEntry.hasRegularItem() : currentEntry.hasConnectingItem());
        graphics.submitSprite(GREY_BUTTONS, (float)this.x, (float)this.y, (float)this.width, (float)this.height, p -> p.uv(0.0f, (float)(canSwitch ? (this.isFocused() ? 2 : 0) : 1) / 3.0f, 1.0f, 0.33333334f));
        graphics.submitSprite(this.connecting.get() != false ? ICON_CONNECTED_ON : ICON_CONNECTED_OFF, (float)(this.x + 1), (float)(this.y + 2), (float)(this.width - 2), (float)(this.height - 4));
    }
}

