/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.packet.PacketChiselAll;
import com.supermartijn642.rechiseled.packet.PacketSelectEntry;
import com.supermartijn642.rechiseled.packet.PacketToggleConnecting;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainer;
import com.supermartijn642.rechiseled.screen.ChiselAllWidget;
import com.supermartijn642.rechiseled.screen.ConnectingToggleWidget;
import com.supermartijn642.rechiseled.screen.EntryButtonWidget;
import com.supermartijn642.rechiseled.screen.EntryPreviewWidget;
import com.supermartijn642.rechiseled.screen.PreviewModeButtonWidget;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BaseChiselingContainerScreen<T extends BaseChiselingContainer>
extends BaseContainerWidget<T> {
    public static final Identifier BACKGROUND = Identifier.fromNamespaceAndPath((String)"rechiseled", (String)"screen/chiseling_background");
    public static int previewMode = 0;
    private final Component title;
    private ChiselAllWidget chiselAllWidget;

    public BaseChiselingContainerScreen(Component title) {
        super(0, 0, 222, 226);
        this.title = title;
    }

    protected void addWidgets() {
        for (int row = 0; row < 5; ++row) {
            for (int column = 0; column < 5; ++column) {
                int index = row * 5 + column;
                int x = 9 + 20 * column;
                int y = 17 + 22 * row;
                this.addWidget((Widget)new EntryButtonWidget(x, y, 20, 22, () -> this.getEntry(index), () -> ((BaseChiselingContainer)this.container).currentEntry, () -> this.selectEntry(index), () -> ((BaseChiselingContainer)this.container).connecting));
            }
        }
        this.addWidget((Widget)new EntryPreviewWidget(117, 17, 68, 69, () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return null;
            }
            return ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        }, () -> previewMode));
        Supplier<Boolean> enablePreviewButtons = () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return false;
            }
            Item currentItem = ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
            return currentItem instanceof BlockItem;
        };
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 18, 19, 21, 2, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 2;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 41, 19, 21, 1, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 1;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 64, 19, 21, 0, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 0;
        }));
        this.addWidget((Widget)new ConnectingToggleWidget(193, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).connecting, () -> ((BaseChiselingContainer)this.container).currentEntry, this::toggleConnecting));
        this.chiselAllWidget = (ChiselAllWidget)this.addWidget((Widget)new ChiselAllWidget(127, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).currentEntry, this::chiselAll));
    }

    public Component getNarrationMessage() {
        return this.title;
    }

    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        graphics.submitSprite(BACKGROUND, 0.0f, 0.0f, (float)this.width, (float)this.height);
        super.renderBackground(context, graphics, mouseX, mouseY);
    }

    public void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (((BaseChiselingContainer)this.container).currentRecipe != null && this.chiselAllWidget != null && this.chiselAllWidget.isFocused()) {
            for (int index = 1; index < ((BaseChiselingContainer)this.container).slots.size(); ++index) {
                Slot slot = ((BaseChiselingContainer)this.container).getSlot(index);
                ItemStack stack = slot.getItem();
                for (ChiselingEntry entry : ((BaseChiselingContainer)this.container).currentRecipe.getEntries()) {
                    if (!stack.getComponentsPatch().isEmpty() || (!entry.hasConnectingItem() || stack.getItem() != entry.getConnectingItem()) && (!entry.hasRegularItem() || stack.getItem() != entry.getRegularItem())) continue;
                    graphics.submitRectangle((float)slot.x, (float)slot.y, 16.0f, 16.0f, p -> p.color(0, 20, 100, 127));
                }
            }
        }
        graphics.nextStratum();
        super.renderForeground(context, graphics, mouseX, mouseY);
        graphics.submitText((FormattedText)ClientUtils.getPlayer().getInventory().getName(), 31.0f, 133.0f);
    }

    private ChiselingEntry getEntry(int index) {
        ChiselingRecipe recipe = ((BaseChiselingContainer)this.container).currentRecipe;
        if (recipe == null) {
            return null;
        }
        return index >= 0 && index < recipe.getEntries().size() ? recipe.getEntries().get(index) : null;
    }

    private void selectEntry(int index) {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketSelectEntry(index));
    }

    private void toggleConnecting() {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketToggleConnecting());
    }

    private void chiselAll() {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketChiselAll());
    }
}

