/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChiselingRecipe {
    private final Identifier recipeId;
    final Identifier parentRecipeId;
    final boolean overwrite;
    private final List<ChiselingEntry> entries;

    private ChiselingRecipe(Identifier recipeId, Identifier parentRecipeId, boolean overwrite, Collection<ChiselingEntry> entries) {
        this.recipeId = recipeId;
        this.parentRecipeId = parentRecipeId;
        this.overwrite = overwrite;
        this.entries = Collections.unmodifiableList(Arrays.asList((ChiselingEntry[])entries.toArray(ChiselingEntry[]::new)));
    }

    ChiselingRecipe(Identifier recipeId, Identifier parentRecipeId, Collection<ChiselingEntry> entries) {
        this(recipeId, parentRecipeId, false, entries);
    }

    public List<ChiselingEntry> getEntries() {
        return this.entries;
    }

    public boolean contains(ItemStack stack) {
        for (ChiselingEntry entry : this.entries) {
            if ((!entry.hasRegularItem() || entry.getRegularItem() != stack.getItem()) && (!entry.hasConnectingItem() || entry.getConnectingItem() != stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public Identifier getRecipeId() {
        return this.recipeId;
    }

    public static class Serializer {
        public static ChiselingRecipe fromJson(Identifier resourceLocation, JsonObject json) {
            ArrayList<ChiselingEntry> chiselingEntries = new ArrayList<ChiselingEntry>();
            String parentRecipeString = GsonHelper.getAsString((JsonObject)json, (String)"parent", null);
            Identifier parentRecipe = parentRecipeString == null ? null : Identifier.parse((String)parentRecipeString);
            boolean overwrite = GsonHelper.getAsBoolean((JsonObject)json, (String)"overwrite", (boolean)false);
            if (!GsonHelper.isArrayNode((JsonObject)json, (String)"entries")) {
                throw new JsonParseException("Recipe must have an 'entries' array!");
            }
            JsonArray array = GsonHelper.getAsJsonArray((JsonObject)json, (String)"entries");
            for (JsonElement element : array) {
                Item connectingItem;
                Item regularItem;
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Recipe entries must be json objects with 'item' and 'connecting_item' keys!");
                }
                JsonObject object = element.getAsJsonObject();
                if (!object.has("item") && !object.has("connecting_item")) {
                    throw new JsonParseException("Recipe entry must be have at least one of 'item' or 'connecting_item' keys!");
                }
                boolean optional = GsonHelper.getAsBoolean((JsonObject)object, (String)"optional", (boolean)false);
                String regularItemName = GsonHelper.getAsString((JsonObject)object, (String)"item", (String)"");
                if (regularItemName.isEmpty()) {
                    regularItem = null;
                } else {
                    regularItem = (Item)Registries.ITEMS.getValue(Identifier.parse((String)regularItemName));
                    if (regularItem == null && !optional) {
                        throw new JsonParseException("Unknown item '" + regularItemName + "'");
                    }
                }
                String connectingItemName = GsonHelper.getAsString((JsonObject)object, (String)"connecting_item", (String)"");
                if (connectingItemName.isEmpty()) {
                    connectingItem = null;
                } else {
                    connectingItem = (Item)Registries.ITEMS.getValue(Identifier.parse((String)connectingItemName));
                    if (connectingItem == null && !optional) {
                        throw new JsonParseException("Unknown item '" + connectingItemName + "'");
                    }
                }
                if (regularItem == null && connectingItem == null) {
                    throw new JsonParseException("Recipe entry must be have at least one of 'item' or 'connecting_item' keys!");
                }
                chiselingEntries.add(new ChiselingEntry(regularItem, connectingItem));
            }
            return new ChiselingRecipe(resourceLocation, parentRecipe, overwrite, chiselingEntries);
        }

        public static ChiselingRecipe fromNetwork(FriendlyByteBuf buffer) {
            ArrayList<ChiselingEntry> chiselingEntries = new ArrayList<ChiselingEntry>();
            Identifier recipeId = buffer.readIdentifier();
            int entries = buffer.readInt();
            for (int i = 0; i < entries; ++i) {
                chiselingEntries.add(new ChiselingEntry(buffer.readBoolean() ? Item.byId((int)buffer.readVarInt()) : null, buffer.readBoolean() ? Item.byId((int)buffer.readVarInt()) : null));
            }
            return new ChiselingRecipe(recipeId, null, false, chiselingEntries);
        }

        public static void toNetwork(FriendlyByteBuf buffer, ChiselingRecipe recipe) {
            buffer.writeIdentifier(recipe.recipeId);
            buffer.writeInt(recipe.entries.size());
            for (ChiselingEntry entry : recipe.entries) {
                buffer.writeBoolean(entry.getRegularItem() != null);
                if (entry.getRegularItem() != null) {
                    buffer.writeVarInt(Item.getId((Item)entry.getRegularItem()));
                }
                buffer.writeBoolean(entry.getConnectingItem() != null);
                if (entry.getConnectingItem() == null) continue;
                buffer.writeVarInt(Item.getId((Item)entry.getConnectingItem()));
            }
        }
    }
}

