/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.rechiseled.ChiselItem;
import java.util.function.Consumer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class ChiselItemRenderer
implements ItemModel.Unbaked {
    public static final MapCodec<ChiselItemRenderer> CODEC = MapCodec.unit((Object)new ChiselItemRenderer());
    private static final ThreadLocal<Boolean> RECURSION_GUARD = ThreadLocal.withInitial(() -> false);
    private static final SpecialModelRenderer<ItemStackRenderState> ICON_RENDERER = new SpecialModelRenderer<ItemStackRenderState>(){

        public void submit(@Nullable ItemStackRenderState iconRenderState, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector output, int combinedLight, int combinedOverlay, boolean hasFoil, int k) {
            if (RECURSION_GUARD.get() != null) {
                return;
            }
            RECURSION_GUARD.set(true);
            poseStack.pushPose();
            poseStack.translate(0.25, 0.75, 1.0);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            iconRenderState.submit(poseStack, output, combinedLight, combinedOverlay, 0);
            poseStack.popPose();
            RECURSION_GUARD.set(false);
        }

        public void getExtents(Consumer<Vector3fc> set) {
        }

        @Nullable
        public ItemStackRenderState extractArgument(ItemStack stack) {
            return null;
        }
    };

    public MapCodec<? extends ItemModel.Unbaked> type() {
        return CODEC;
    }

    public ItemModel bake(ItemModel.BakingContext bakingContext) {
        return (renderState, stack, modelResolver, transformType, level, entity, someRandomId) -> {
            if (transformType != ItemDisplayContext.GUI || RECURSION_GUARD.get() != null) {
                return;
            }
            ItemStack storedStack = ChiselItem.getStoredStack(stack);
            if (!storedStack.isEmpty()) {
                ItemStackRenderState iconRenderState = new ItemStackRenderState(this){

                    public void appendModelIdentityElement(Object object) {
                        renderState.appendModelIdentityElement(object);
                    }
                };
                RECURSION_GUARD.set(true);
                ClientUtils.getMinecraft().getItemModelResolver().updateForTopItem(iconRenderState, storedStack, ItemDisplayContext.GUI, (Level)level, entity, someRandomId);
                RECURSION_GUARD.remove();
                renderState.newLayer().setupSpecialModel(ICON_RENDERER, (Object)iconRenderState);
                renderState.appendModelIdentityElement((Object)storedStack.getItem());
            }
        };
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
    }
}

