/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class CopyComponentsRecipe
extends CustomRecipe {
    private final Ingredient sourceIngredient;
    private final Ingredient targetIngredient;
    private final List<Identifier> components;

    public CopyComponentsRecipe(Ingredient sourceIngredient, Ingredient targetIngredient, List<Identifier> components) {
        super(CraftingBookCategory.MISC);
        this.sourceIngredient = sourceIngredient;
        this.targetIngredient = targetIngredient;
        this.components = components;
    }

    public Pair<ItemStack, List<ItemStack>> getResult(CraftingInput inv) {
        ItemStack source = null;
        ArrayList<ItemStack> toCopy = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            boolean matchesSource = this.sourceIngredient.test(stack);
            boolean matchesTarget = this.targetIngredient.test(stack);
            if (!matchesSource && !matchesTarget) {
                return new Pair(null, new ArrayList());
            }
            if (matchesSource && source == null && this.hasComponent(stack)) {
                source = stack;
                continue;
            }
            if (matchesTarget && !this.hasComponent(stack)) {
                toCopy.add(stack);
                continue;
            }
            return new Pair(null, new ArrayList());
        }
        return new Pair(source, toCopy);
    }

    private boolean hasComponent(ItemStack stack) {
        return stack.getComponentsPatch().entrySet().stream().map(Map.Entry::getKey).map(arg_0 -> ((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE).getKey(arg_0)).anyMatch(this.components::contains);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null || result.getValue().isEmpty()) {
            return false;
        }
        return result.getValue().size() == 1 || result.getValue().stream().allMatch(stack -> stack.getItem().equals(((ItemStack)result.getKey()).getItem()));
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return ItemStack.EMPTY;
        }
        if (result.getValue().stream().allMatch(stack -> stack.getItem().equals(((ItemStack)result.getKey()).getItem()))) {
            ItemStack res = result.getKey().copy();
            res.setCount(1 + result.getValue().size());
            return res;
        }
        if (result.getValue().size() == 1) {
            ItemStack stack2 = result.getValue().get(0).copy();
            stack2.setCount(1);
            DataComponentPatch patch = result.getKey().getComponentsPatch();
            for (Map.Entry e : patch.entrySet()) {
                Identifier key;
                if (((Optional)e.getValue()).isEmpty() || (key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)e.getKey()))) == null || !this.components.contains(key)) continue;
                stack2.set((DataComponentType)e.getKey(), ((Optional)e.getValue()).get());
            }
            return stack2;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return super.getRemainingItems(inv);
        }
        if (result.getValue().stream().allMatch(stack -> stack.getItem().equals(((ItemStack)result.getKey()).getItem()))) {
            return super.getRemainingItems(inv);
        }
        if (result.getValue().size() == 1) {
            NonNullList res = super.getRemainingItems(inv);
            for (int i = 0; i < inv.size(); ++i) {
                if (!inv.getItem(i).equals(result.getKey())) continue;
                ItemStack r = result.getKey().copy();
                r.setCount(1);
                res.set(i, (Object)r);
                break;
            }
            return res;
        }
        return super.getRemainingItems(inv);
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipes.COPY_NBT.get();
    }

    public static class Serializer
    implements RecipeSerializer<CopyComponentsRecipe> {
        private static final MapCodec<CopyComponentsRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("source").forGetter(recipe -> recipe.sourceIngredient), (App)Ingredient.CODEC.fieldOf("target").forGetter(recipe -> recipe.targetIngredient), (App)Codec.list((Codec)Identifier.CODEC).fieldOf("components").forGetter(recipe -> recipe.components)).apply((Applicative)builder, CopyComponentsRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, CopyComponentsRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.sourceIngredient, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.targetIngredient, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)Identifier.STREAM_CODEC), r -> r.components, CopyComponentsRecipe::new);

        public MapCodec<CopyComponentsRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CopyComponentsRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

