/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.items;

import de.maxhenkel.pipez.tags.ModItemTags;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class WrenchItem
extends Item {
    public static final Component WRENCH_TOOLTIP = Component.translatable((String)"tooltip.pipez.wrench").withStyle(ChatFormatting.GRAY);

    public WrenchItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flag) {
        consumer.accept(WRENCH_TOOLTIP);
        super.appendHoverText(stack, context, tooltipDisplay, consumer, flag);
    }

    public static boolean isWrench(ItemStack stack) {
        return stack.is(ModItemTags.WRENCH_TAG) || stack.is(ModItemTags.WRENCHES_TAG);
    }

    public static boolean isHoldingWrench(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!WrenchItem.isWrench(stack)) continue;
            return true;
        }
        return false;
    }
}

