/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.corelib.client;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;

public class PlayerSkins {
    private static final Map<UUID, GameProfile> PLAYERS = new ConcurrentHashMap<UUID, GameProfile>();

    public static PlayerSkin getSkin(UUID uuid) {
        return PlayerSkins.getSkin(PlayerSkins.getGameProfile(uuid));
    }

    public static PlayerSkin getSkin(Player player) {
        return PlayerSkins.getSkin(player.getGameProfile());
    }

    public static PlayerSkin getSkin(GameProfile gameProfile) {
        PlayerSkinRenderCache.RenderInfo renderInfo = Minecraft.getInstance().playerSkinRenderCache().getOrDefault(ResolvableProfile.createResolved((GameProfile)gameProfile));
        return renderInfo.playerSkin();
    }

    public static GameProfile getGameProfile(UUID uuid) {
        if (PLAYERS.containsKey(uuid)) {
            return PLAYERS.get(uuid);
        }
        ResolvableProfile resolvableProfile = ResolvableProfile.createUnresolved((UUID)uuid);
        GameProfile gameProfile = resolvableProfile.partialProfile();
        PLAYERS.put(uuid, gameProfile);
        resolvableProfile.resolveProfile(Minecraft.getInstance().services().profileResolver()).thenAcceptAsync(profile -> PLAYERS.put(uuid, (GameProfile)profile));
        return gameProfile;
    }

    public static boolean isSlim(UUID uuid) {
        return PlayerModelType.SLIM.equals((Object)PlayerSkins.getSkin(uuid).model());
    }

    public static boolean isSlim(Player player) {
        return PlayerSkins.isSlim(player.getUUID());
    }
}

