/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.datacomponents.AbstractPipeTypeData;
import de.maxhenkel.pipez.items.UpgradeItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;

public abstract class PipeType<T, D extends AbstractPipeTypeData<T>> {
    public abstract void tick(PipeLogicTileEntity var1);

    public abstract int getRate(@Nullable Upgrade var1);

    public abstract BlockCapability<?, Direction> getCapability();

    @Nullable
    public abstract Filter<?, T> createFilter();

    public abstract String getTranslationKey();

    public abstract ItemStack getIcon();

    public abstract Component getTransferText(@Nullable Upgrade var1);

    public boolean hasFilter() {
        return true;
    }

    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.ROUND_ROBIN;
    }

    public UpgradeTileEntity.RedstoneMode getDefaultRedstoneMode() {
        return UpgradeTileEntity.RedstoneMode.IGNORED;
    }

    public UpgradeTileEntity.FilterMode getDefaultFilterMode() {
        return UpgradeTileEntity.FilterMode.WHITELIST;
    }

    public int getRate(PipeLogicTileEntity tileEntity, Direction direction) {
        return this.getRate(tileEntity.getUpgrade(direction));
    }

    public boolean matchesConnection(PipeTileEntity.Connection connection, Filter<?, T> filter) {
        if (filter.getDestination() == null) {
            return true;
        }
        return filter.getDestination().equals(new DirectionalPosition(connection.getPos(), connection.getDirection()));
    }

    public boolean deepExactCompare(Tag meta, Tag item) {
        if (meta instanceof CompoundTag) {
            if (!(item instanceof CompoundTag)) {
                return false;
            }
            CompoundTag c = (CompoundTag)meta;
            CompoundTag i = (CompoundTag)item;
            HashSet allKeys = new HashSet();
            allKeys.addAll(c.keySet());
            allKeys.addAll(i.keySet());
            for (String key : allKeys) {
                if (c.contains(key)) {
                    if (i.contains(key)) {
                        Tag nbt = c.get(key);
                        if (this.deepExactCompare(nbt, i.get(key))) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        if (meta instanceof ListTag) {
            ListTag l = (ListTag)meta;
            if (!(item instanceof ListTag)) {
                return false;
            }
            ListTag il = (ListTag)item;
            if (!l.stream().allMatch(inbt -> il.stream().anyMatch(inbt1 -> this.deepExactCompare((Tag)inbt, (Tag)inbt1)))) {
                return false;
            }
            return il.stream().allMatch(inbt -> l.stream().anyMatch(inbt1 -> this.deepExactCompare((Tag)inbt, (Tag)inbt1)));
        }
        return meta != null && meta.equals((Object)item);
    }

    public boolean deepFuzzyCompare(Tag meta, Tag item) {
        if (meta instanceof CompoundTag) {
            if (!(item instanceof CompoundTag)) {
                return false;
            }
            CompoundTag c = (CompoundTag)meta;
            CompoundTag i = (CompoundTag)item;
            for (String key : c.keySet()) {
                Tag nbt = c.get(key);
                Tag iNbt = i.get(key);
                if (nbt != null && iNbt != null && iNbt.getId() == nbt.getId()) {
                    if (this.deepFuzzyCompare(nbt, iNbt)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        if (meta instanceof ListTag) {
            ListTag l = (ListTag)meta;
            if (!(item instanceof ListTag)) {
                return false;
            }
            ListTag il = (ListTag)item;
            return l.stream().allMatch(inbt -> il.stream().anyMatch(inbt1 -> this.deepFuzzyCompare((Tag)inbt, (Tag)inbt1)));
        }
        return meta != null && meta.equals((Object)item);
    }

    public static int getConnectionsNotFullCount(boolean[] connections) {
        int count = 0;
        for (boolean connection : connections) {
            if (connection) continue;
            ++count;
        }
        return count;
    }

    public BlockCapability<?, Direction>[] getCapabilities() {
        return new BlockCapability[]{this.getCapability()};
    }

    public abstract DataComponentType<D> getDataComponentType();

    public abstract D defaultData();

    private D getOrDefault(ItemStack stack) {
        AbstractPipeTypeData<Object> data = (AbstractPipeTypeData)stack.get(this.getDataComponentType());
        if (data == null) {
            data = this.defaultData();
        }
        return (D)data;
    }

    @Nullable
    private Upgrade getUpgrade(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof UpgradeItem)) {
            return null;
        }
        UpgradeItem upgradeItem = (UpgradeItem)item;
        return upgradeItem.getTier();
    }

    public List<Filter<?, ?>> getFilters(ItemStack stack) {
        Upgrade upgrade = this.getUpgrade(stack);
        if (!Upgrade.canChangeFilter(upgrade)) {
            return new ArrayList();
        }
        AbstractPipeTypeData data = (AbstractPipeTypeData)stack.get(this.getDataComponentType());
        if (data == null) {
            return new ArrayList();
        }
        return data.copyFilterList();
    }

    public void setFilters(ItemStack stack, List<Filter<?, ?>> value) {
        stack.set(this.getDataComponentType(), ((AbstractPipeTypeData.PipeTypeDataBuilder)((AbstractPipeTypeData)this.getOrDefault(stack)).builder().filters(value)).build());
    }

    public UpgradeTileEntity.RedstoneMode getRedstoneMode(ItemStack stack) {
        Upgrade upgrade = this.getUpgrade(stack);
        if (!Upgrade.canChangeRedstoneMode(upgrade)) {
            return this.getDefaultRedstoneMode();
        }
        AbstractPipeTypeData data = (AbstractPipeTypeData)stack.get(this.getDataComponentType());
        if (data == null) {
            return this.getDefaultRedstoneMode();
        }
        return data.getRedstoneMode();
    }

    public void setRedstoneMode(ItemStack stack, UpgradeTileEntity.RedstoneMode value) {
        Upgrade upgrade = this.getUpgrade(stack);
        if (!Upgrade.canChangeRedstoneMode(upgrade)) {
            return;
        }
        stack.set(this.getDataComponentType(), ((AbstractPipeTypeData.PipeTypeDataBuilder)((AbstractPipeTypeData)this.getOrDefault(stack)).builder().redstoneMode(value)).build());
    }

    public UpgradeTileEntity.FilterMode getFilterMode(ItemStack stack) {
        Upgrade upgrade = this.getUpgrade(stack);
        if (!Upgrade.canChangeFilter(upgrade)) {
            return this.getDefaultFilterMode();
        }
        AbstractPipeTypeData data = (AbstractPipeTypeData)stack.get(this.getDataComponentType());
        if (data == null) {
            return this.getDefaultFilterMode();
        }
        return data.getFilterMode();
    }

    public void setFilterMode(ItemStack stack, UpgradeTileEntity.FilterMode value) {
        Upgrade upgrade = this.getUpgrade(stack);
        if (!Upgrade.canChangeFilter(upgrade)) {
            return;
        }
        stack.set(this.getDataComponentType(), ((AbstractPipeTypeData.PipeTypeDataBuilder)((AbstractPipeTypeData)this.getOrDefault(stack)).builder().filterMode(value)).build());
    }

    public UpgradeTileEntity.Distribution getDistribution(ItemStack stack) {
        Upgrade upgrade = this.getUpgrade(stack);
        if (!Upgrade.canChangeDistributionMode(upgrade)) {
            return this.getDefaultDistribution();
        }
        AbstractPipeTypeData data = (AbstractPipeTypeData)stack.get(this.getDataComponentType());
        if (data == null) {
            return this.getDefaultDistribution();
        }
        return data.getDistribution();
    }

    public void setDistribution(ItemStack stack, UpgradeTileEntity.Distribution value) {
        Upgrade upgrade = this.getUpgrade(stack);
        if (!Upgrade.canChangeDistributionMode(upgrade)) {
            return;
        }
        stack.set(this.getDataComponentType(), ((AbstractPipeTypeData.PipeTypeDataBuilder)((AbstractPipeTypeData)this.getOrDefault(stack)).builder().distribution(value)).build());
    }
}

