/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.PipezMod;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.ModBlocks;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.datacomponents.FluidData;
import de.maxhenkel.pipez.items.ModItems;
import de.maxhenkel.pipez.utils.ComponentUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.fluid.FluidResource;

public class FluidPipeType
extends PipeType<Fluid, FluidData> {
    public static final FluidPipeType INSTANCE = new FluidPipeType();
    private static final FluidData DEFAULT = new FluidData(UpgradeTileEntity.FilterMode.WHITELIST, UpgradeTileEntity.RedstoneMode.IGNORED, UpgradeTileEntity.Distribution.ROUND_ROBIN, Collections.emptyList());

    @Override
    public BlockCapability<?, Direction> getCapability() {
        return Capabilities.Fluid.BLOCK;
    }

    @Override
    @Nullable
    public Filter<?, Fluid> createFilter() {
        return new FluidFilter();
    }

    @Override
    public String getTranslationKey() {
        return "tooltip.pipez.fluid";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ModBlocks.FLUID_PIPE.get());
    }

    @Override
    public Component getTransferText(@Nullable Upgrade upgrade) {
        return Component.translatable((String)"tooltip.pipez.rate.fluid", (Object[])new Object[]{this.getRate(upgrade)});
    }

    @Override
    public void tick(PipeLogicTileEntity tileEntity) {
        for (Direction side : Direction.values()) {
            ResourceHandler<FluidResource> fluidHandler;
            PipeTileEntity.Connection extractingConnection;
            if (!tileEntity.isExtracting(side) || !tileEntity.shouldWork(side, this) || (extractingConnection = tileEntity.getExtractingConnection(side)) == null || (fluidHandler = extractingConnection.getFluidHandler()) == null) continue;
            List<PipeTileEntity.Connection> connections = tileEntity.getSortedConnections(side, this);
            if (tileEntity.getDistribution(side, this).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(tileEntity, side, connections, fluidHandler);
                continue;
            }
            this.insertOrdered(tileEntity, side, connections, fluidHandler);
        }
    }

    protected void insertEqually(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, ResourceHandler<FluidResource> fluidHandler) {
        int completeAmount;
        if (connections.isEmpty()) {
            return;
        }
        int mbToTransfer = completeAmount = this.getRate(tileEntity, side);
        boolean[] connectionsFull = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, this) % connections.size();
        while (mbToTransfer > 0 && this.hasNotInserted(connectionsFull)) {
            int moved;
            PipeTileEntity.Connection connection = connections.get(p);
            ResourceHandler<FluidResource> destination = connection.getFluidHandler();
            boolean hasInserted = false;
            if (destination != null && !connectionsFull[p] && (moved = ResourceHandlerUtil.move(fluidHandler, destination, resource -> this.canInsert((HolderLookup.Provider)tileEntity.getLevel().registryAccess(), connection, (FluidResource)resource, tileEntity.getFilters(side, this)) != tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST), (int)Math.min(Math.max(completeAmount / FluidPipeType.getConnectionsNotFullCount(connectionsFull), 1), mbToTransfer), null)) > 0) {
                mbToTransfer -= moved;
                hasInserted = true;
            }
            if (!hasInserted) {
                connectionsFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, this, p);
    }

    protected void insertOrdered(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, ResourceHandler<FluidResource> fluidHandler) {
        int moved;
        PipeTileEntity.Connection connection;
        ResourceHandler<FluidResource> destination;
        int mbToTransfer = this.getRate(tileEntity, side);
        Iterator<PipeTileEntity.Connection> iterator = connections.iterator();
        while (iterator.hasNext() && ((destination = (connection = iterator.next()).getFluidHandler()) == null || (mbToTransfer -= (moved = ResourceHandlerUtil.move(fluidHandler, destination, resource -> this.canInsert((HolderLookup.Provider)tileEntity.getLevel().registryAccess(), connection, (FluidResource)resource, tileEntity.getFilters(side, this)) != tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST), (int)mbToTransfer, null))) > 0)) {
        }
    }

    private boolean canInsert(HolderLookup.Provider provider, PipeTileEntity.Connection connection, FluidResource resource, List<Filter<?, ?>> filters) {
        for (Filter filter2 : filters.stream().map(filter -> filter).filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(provider, filter2, resource)) continue;
            return false;
        }
        List collect = filters.stream().map(filter -> filter).filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter3 : collect) {
            if (!this.matches(provider, filter3, resource)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(HolderLookup.Provider provider, Filter<?, Fluid> filter, FluidResource resource) {
        CompoundTag metadata = filter.getMetadata();
        if (metadata == null) {
            return filter.getTag() == null || filter.getTag().contains(resource.getFluid());
        }
        CompoundTag stackNBT = ComponentUtils.getTag(provider, resource.toStack(1));
        if (filter.isExactMetadata()) {
            if (this.deepExactCompare((Tag)metadata, (Tag)stackNBT)) {
                return filter.getTag() == null || filter.getTag().contains(resource.getFluid());
            }
            return false;
        }
        if (stackNBT.isEmpty()) {
            return metadata.size() <= 0;
        }
        if (!this.deepFuzzyCompare((Tag)metadata, (Tag)stackNBT)) {
            return false;
        }
        return filter.getTag() == null || filter.getTag().contains(resource.getFluid());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRate(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)PipezMod.SERVER_CONFIG.fluidPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)PipezMod.SERVER_CONFIG.fluidPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)PipezMod.SERVER_CONFIG.fluidPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)PipezMod.SERVER_CONFIG.fluidPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)PipezMod.SERVER_CONFIG.fluidPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public DataComponentType<FluidData> getDataComponentType() {
        return (DataComponentType)ModItems.FLUID_DATA_COMPONENT.get();
    }

    @Override
    public FluidData defaultData() {
        return DEFAULT;
    }
}

