/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks;

import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.corelib.block.VoxelUtils;
import de.maxhenkel.pipez.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.corelib.helpers.Triple;
import de.maxhenkel.pipez.items.UpgradeItem;
import de.maxhenkel.pipez.items.WrenchItem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PipeBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty HAS_DATA = BooleanProperty.create((String)"has_data");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE_NORTH = Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_UP = Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape SHAPE_DOWN = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
    public static final VoxelShape SHAPE_CORE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_EXTRACT_NORTH = VoxelUtils.combine(SHAPE_NORTH, Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0));
    public static final VoxelShape SHAPE_EXTRACT_SOUTH = VoxelUtils.combine(SHAPE_SOUTH, Block.box((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0));
    public static final VoxelShape SHAPE_EXTRACT_EAST = VoxelUtils.combine(SHAPE_EAST, Block.box((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_WEST = VoxelUtils.combine(SHAPE_WEST, Block.box((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_UP = VoxelUtils.combine(SHAPE_UP, Block.box((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_DOWN = VoxelUtils.combine(SHAPE_DOWN, Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0));
    private static final List<Triple<VoxelShape, BooleanProperty, Direction>> SHAPES = Arrays.asList(new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_NORTH, NORTH, Direction.NORTH), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_SOUTH, SOUTH, Direction.SOUTH), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_WEST, WEST, Direction.WEST), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_EAST, EAST, Direction.EAST), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_UP, UP, Direction.UP), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_DOWN, DOWN, Direction.DOWN));
    private static final List<Pair<VoxelShape, Direction>> EXTRACT_SHAPES = Arrays.asList(new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_NORTH, Direction.NORTH), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_SOUTH, Direction.SOUTH), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_WEST, Direction.WEST), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_EAST, Direction.EAST), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_UP, Direction.UP), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_DOWN, Direction.DOWN));

    protected PipeBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_GRAY).strength(0.5f).sound(SoundType.METAL).pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_DATA, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction side = this.getSelection(state, (BlockGetter)level, pos, player).getKey();
        if (side != null) {
            return this.onPipeSideActivated(itemStack, state, level, pos, player, hand, hit, side);
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, hit);
    }

    public InteractionResult onWrenchClicked(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, Direction side) {
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (side != null) {
            if (worldIn.getBlockState(pos.relative(side)).getBlock() != this) {
                boolean extracting = this.isExtracting((LevelAccessor)worldIn, pos, side);
                if (extracting) {
                    this.setExtracting(worldIn, pos, side, false);
                    this.setDisconnected(worldIn, pos, side, true);
                } else {
                    this.setExtracting(worldIn, pos, side, true);
                    this.setDisconnected(worldIn, pos, side, false);
                }
            } else {
                this.setDisconnected(worldIn, pos, side, true);
            }
        } else {
            side = hit.getDirection();
            if (worldIn.getBlockState(pos.relative(side)).getBlock() != this) {
                this.setExtracting(worldIn, pos, side, false);
                if (this.isAbleToConnect(worldIn, pos, side)) {
                    this.setDisconnected(worldIn, pos, side, false);
                }
            } else {
                this.setDisconnected(worldIn, pos, side, false);
                this.setDisconnected(worldIn, pos.relative(side), side.getOpposite(), false);
            }
        }
        PipeTileEntity.markPipesDirty(worldIn, pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onPipeSideActivated(ItemStack itemStack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, Direction direction) {
        return super.useItemOn(itemStack, state, worldIn, pos, player, handIn, hit);
    }

    public InteractionResult onPipeSideForceActivated(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable Direction side) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (WrenchItem.isWrench(heldItem)) {
            return this.onWrenchClicked(state, world, pos, player, hand, hit, side);
        }
        if (heldItem.getItem() instanceof UpgradeItem && player.isShiftKeyDown() && side != null) {
            BlockEntity te = world.getBlockEntity(pos);
            if (!(te instanceof UpgradeTileEntity)) {
                return InteractionResult.PASS;
            }
            UpgradeTileEntity upgradeTe = (UpgradeTileEntity)te;
            if (!upgradeTe.isExtracting(side)) {
                return InteractionResult.PASS;
            }
            ItemStack oldUpgrade = player.getAbilities().instabuild ? upgradeTe.setUpgradeItem(side, heldItem.copy().split(1)) : upgradeTe.setUpgradeItem(side, heldItem.split(1));
            if (heldItem.isEmpty()) {
                player.setItemInHand(hand, oldUpgrade);
            } else if (!player.getInventory().add(oldUpgrade)) {
                player.drop(oldUpgrade, true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BooleanProperty getProperty(Direction side) {
        switch (side) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
        }
        return DOWN;
    }

    public boolean isExtracting(LevelAccessor world, BlockPos pos, Direction side) {
        PipeTileEntity pipe = this.getTileEntity(world, pos);
        if (pipe == null) {
            return false;
        }
        return pipe.isExtracting(side);
    }

    public boolean isDisconnected(LevelAccessor world, BlockPos pos, Direction side) {
        PipeTileEntity pipe = this.getTileEntity(world, pos);
        if (pipe == null) {
            return false;
        }
        return pipe.isDisconnected(side);
    }

    public void setHasData(Level world, BlockPos pos, boolean hasData) {
        BlockState blockState = world.getBlockState(pos);
        world.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)HAS_DATA, (Comparable)Boolean.valueOf(hasData)));
        if (!hasData) {
            world.removeBlockEntity(pos);
        }
    }

    public void setExtracting(Level world, BlockPos pos, Direction side, boolean extracting) {
        boolean connected;
        BooleanProperty sideProperty;
        BlockState blockState;
        PipeTileEntity pipe = this.getTileEntity((LevelAccessor)world, pos);
        if (pipe == null) {
            if (extracting) {
                this.setHasData(world, pos, true);
                pipe = this.getTileEntity((LevelAccessor)world, pos);
                if (pipe != null) {
                    pipe.setExtracting(side, extracting);
                }
            }
        } else {
            pipe.setExtracting(side, extracting);
            if (!pipe.hasReasonToStay()) {
                this.setHasData(world, pos, false);
            }
        }
        world.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)sideProperty, (Comparable)Boolean.valueOf(!(connected = ((Boolean)(blockState = world.getBlockState(pos)).getValue((Property)(sideProperty = this.getProperty(side)))).booleanValue()))));
        world.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)sideProperty, (Comparable)Boolean.valueOf(connected)));
    }

    public void setDisconnected(Level world, BlockPos pos, Direction side, boolean disconnected) {
        PipeTileEntity pipe = this.getTileEntity((LevelAccessor)world, pos);
        if (pipe == null) {
            if (disconnected) {
                this.setHasData(world, pos, true);
                pipe = this.getTileEntity((LevelAccessor)world, pos);
                if (pipe != null) {
                    pipe.setDisconnected(side, disconnected);
                    world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)this.getProperty(side), (Comparable)Boolean.valueOf(false)));
                }
            }
        } else {
            pipe.setDisconnected(side, disconnected);
            if (!pipe.hasReasonToStay()) {
                this.setHasData(world, pos, false);
            }
            world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)this.getProperty(side), (Comparable)Boolean.valueOf(!disconnected)));
        }
    }

    @Nullable
    public PipeTileEntity getTileEntity(LevelAccessor world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof PipeTileEntity) {
            return (PipeTileEntity)te;
        }
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getState(context.getLevel(), context.getClickedPos(), null);
    }

    private BlockState getState(Level world, BlockPos pos, @Nullable BlockState oldState) {
        FluidState fluidState = world.getFluidState(pos);
        boolean hasData = false;
        if (oldState != null && oldState.getBlock() == this) {
            hasData = (Boolean)oldState.getValue((Property)HAS_DATA);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(this.isConnected(world, pos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.isConnected(world, pos, Direction.DOWN)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.isConnected(world, pos, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.isConnected(world, pos, Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.isConnected(world, pos, Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.isConnected(world, pos, Direction.WEST)))).setValue((Property)HAS_DATA, (Comparable)Boolean.valueOf(hasData))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
    }

    public boolean isConnected(Level world, BlockPos pos, Direction facing) {
        boolean canSelfConnect;
        PipeTileEntity pipe = this.getTileEntity((LevelAccessor)world, pos);
        PipeTileEntity other = this.getTileEntity((LevelAccessor)world, pos.relative(facing));
        if (!this.isAbleToConnect(world, pos, facing)) {
            return false;
        }
        boolean bl = canSelfConnect = pipe == null || !pipe.isDisconnected(facing);
        if (!canSelfConnect) {
            return false;
        }
        boolean canSideConnect = other == null || !other.isDisconnected(facing.getOpposite());
        return canSideConnect;
    }

    public boolean isAbleToConnect(Level world, BlockPos pos, Direction facing) {
        return this.isPipe((LevelAccessor)world, pos, facing) || this.canConnectTo(world, pos, facing);
    }

    public abstract boolean canConnectTo(Level var1, BlockPos var2, Direction var3);

    public abstract boolean isPipe(LevelAccessor var1, BlockPos var2, Direction var3);

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos pos1, BlockState state1, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, direction, pos1, state1, randomSource);
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, @Nullable Orientation orientation, boolean b) {
        super.neighborChanged(state, world, pos, block, orientation, b);
        BlockState newState = this.getState(world, pos, state);
        if (!state.getProperties().stream().allMatch(property -> state.getValue(property).equals(newState.getValue(property)))) {
            world.setBlockAndUpdate(pos, newState);
            PipeTileEntity.markPipesDirty(world, pos);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, HAS_DATA, WATERLOGGED});
    }

    public VoxelShape getShape(BlockGetter blockReader, BlockPos pos, BlockState state, boolean advanced) {
        PipeTileEntity pipe = null;
        if (advanced && blockReader instanceof LevelAccessor) {
            pipe = this.getTileEntity((LevelAccessor)blockReader, pos);
        }
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.UP) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_UP) : VoxelUtils.combine(shape, SHAPE_UP);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.DOWN) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_DOWN) : VoxelUtils.combine(shape, SHAPE_DOWN);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.SOUTH) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_SOUTH) : VoxelUtils.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.NORTH) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_NORTH) : VoxelUtils.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.EAST) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_EAST) : VoxelUtils.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.WEST) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_WEST) : VoxelUtils.combine(shape, SHAPE_WEST);
        }
        return shape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Player player;
        EntityCollisionContext ctx;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (ctx = (EntityCollisionContext)context).getEntity()) instanceof Player && (player = (Player)entity).level().isClientSide()) {
            return this.getSelectionShape(state, worldIn, pos, player);
        }
        return this.getShape(worldIn, pos, state, true);
    }

    public VoxelShape getSelectionShape(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Pair<Direction, VoxelShape> selection = this.getSelection(state, world, pos, player);
        if (selection.getKey() == null) {
            return this.getShape(world, pos, state, true);
        }
        if (world.getBlockState(pos.relative(selection.getKey())).getBlock() == this && !WrenchItem.isHoldingWrench(player)) {
            return this.getShape(world, pos, state, true);
        }
        return selection.getValue();
    }

    public Pair<Direction, VoxelShape> getSelection(BlockState state, BlockGetter blockReader, BlockPos pos, Player player) {
        Vec3 start = player.getEyePosition(1.0f);
        Vec3 end = start.add(player.getLookAngle().normalize().scale((double)this.getBlockReachDistance(player)));
        Direction direction = null;
        VoxelShape selection = null;
        double shortest = Double.MAX_VALUE;
        double d = this.checkShape(state, blockReader, pos, start, end, SHAPE_CORE, null);
        if (d < shortest) {
            shortest = d;
        }
        if (!(blockReader instanceof LevelAccessor)) {
            return new Pair<Object, Object>(direction, selection);
        }
        PipeTileEntity pipe = this.getTileEntity((LevelAccessor)blockReader, pos);
        for (int i = 0; i < Direction.values().length; ++i) {
            Pair<VoxelShape, Direction> extract = EXTRACT_SHAPES.get(i);
            Triple<VoxelShape, BooleanProperty, Direction> shape = SHAPES.get(i);
            if (pipe != null && pipe.isExtracting(extract.getValue())) {
                d = this.checkShape(state, blockReader, pos, start, end, extract.getKey(), pipe, extract.getValue());
                if (!(d < shortest)) continue;
                shortest = d;
                direction = extract.getValue();
                selection = extract.getKey();
                continue;
            }
            d = this.checkShape(state, blockReader, pos, start, end, shape.getValue1(), shape.getValue2());
            if (!(d < shortest)) continue;
            shortest = d;
            direction = shape.getValue3();
            selection = shape.getValue1();
        }
        return new Pair<Object, Object>(direction, selection);
    }

    public float getBlockReachDistance(Player player) {
        AttributeInstance attribute = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (attribute == null) {
            return (float)((Attribute)Attributes.BLOCK_INTERACTION_RANGE.value()).getDefaultValue();
        }
        return (float)attribute.getValue();
    }

    private double checkShape(BlockState state, BlockGetter world, BlockPos pos, Vec3 start, Vec3 end, VoxelShape shape, BooleanProperty direction) {
        if (direction != null && !((Boolean)state.getValue((Property)direction)).booleanValue()) {
            return Double.MAX_VALUE;
        }
        BlockHitResult blockRayTraceResult = world.clipWithInteractionOverride(start, end, pos, shape, state);
        if (blockRayTraceResult == null) {
            return Double.MAX_VALUE;
        }
        return blockRayTraceResult.getLocation().distanceTo(start);
    }

    private double checkShape(BlockState state, BlockGetter world, BlockPos pos, Vec3 start, Vec3 end, VoxelShape shape, @Nullable PipeTileEntity pipe, Direction side) {
        if (pipe != null && !pipe.isExtracting(side)) {
            return Double.MAX_VALUE;
        }
        BlockHitResult blockRayTraceResult = world.clipWithInteractionOverride(start, end, pos, shape, state);
        if (blockRayTraceResult == null) {
            return Double.MAX_VALUE;
        }
        return blockRayTraceResult.getLocation().distanceTo(start);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos pos, boolean moving) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof UpgradeTileEntity) {
            UpgradeTileEntity upgrade = (UpgradeTileEntity)blockentity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)upgrade.getUpgradeInventory());
        }
        super.affectNeighborsAfterRemoval(blockState, level, pos, moving);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(reader, pos, state, false);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(worldIn, pos, state, false);
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(reader, pos, state, false);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.getShape(worldIn, pos, state, false);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)HAS_DATA)).booleanValue()) {
            return this.createTileEntity(pos, state);
        }
        return null;
    }

    abstract BlockEntity createTileEntity(BlockPos var1, BlockState var2);
}

