/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.utils.NbtUtils;
import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;

public abstract class Filter<F extends Filter<F, T>, T> {
    protected UUID id;
    @Nullable
    protected Tag<T> tag;
    @Nullable
    protected CompoundTag metadata;
    protected boolean exactMetadata;
    @Nullable
    protected DirectionalPosition destination;
    protected boolean invert;
    private static final Codec<TagData> TAG_DATA_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("type").xmap(TagType::valueOf, Enum::name).forGetter(TagData::tagType), (App)Identifier.CODEC.fieldOf("tag").forGetter(TagData::location)).apply((Applicative)i, TagData::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, TagData> TAG_DATA_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, TagData::isSingle, (StreamCodec)Identifier.STREAM_CODEC, TagData::location, TagData::new);

    public Filter(UUID id, @Nullable Tag<T> tag, @Nullable CompoundTag metadata, boolean exactMetadata, @Nullable DirectionalPosition destination, boolean invert) {
        this.id = id;
        this.tag = tag;
        this.metadata = metadata;
        this.exactMetadata = exactMetadata;
        this.destination = destination;
        this.invert = invert;
    }

    public UUID getId() {
        return this.id;
    }

    @Nullable
    public Tag<T> getTag() {
        return this.tag;
    }

    public void setTag(@Nullable Tag<T> tag) {
        this.tag = tag;
    }

    @Nullable
    public CompoundTag getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable CompoundTag metadata) {
        this.metadata = metadata;
    }

    @Nullable
    public DirectionalPosition getDestination() {
        return this.destination;
    }

    public void setDestination(@Nullable DirectionalPosition destination) {
        this.destination = destination;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean isExactMetadata() {
        return this.exactMetadata;
    }

    public void setExactMetadata(boolean exactMetadata) {
        this.exactMetadata = exactMetadata;
    }

    public F copy() {
        try {
            Filter copiedFilter = (Filter)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            copiedFilter.id = this.id;
            copiedFilter.tag = this.tag;
            copiedFilter.metadata = this.metadata;
            copiedFilter.exactMetadata = this.exactMetadata;
            copiedFilter.destination = this.destination;
            copiedFilter.invert = this.invert;
            return (F)copiedFilter;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract Codec<F> getCodec();

    public abstract StreamCodec<RegistryFriendlyByteBuf, F> getStreamCodec();

    public CompoundTag toNbt() {
        return NbtUtils.codecToNbtDefault(this.getCodec(), this);
    }

    public Filter fromNbt(CompoundTag tag) {
        return NbtUtils.nbtToCodecOptional(this.getCodec(), tag).orElse(this);
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        this.getStreamCodec().encode((Object)buffer, (Object)this);
    }

    public Filter fromNetwork(RegistryFriendlyByteBuf buffer) {
        return (Filter)this.getStreamCodec().decode((Object)buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        return Objects.equals(this.id, filter.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public static <T, U extends Filter<U, T>> Codec<U> codec(Class<U> clazz, Codec<Tag<T>> tagCodec) {
        Constructor constructor;
        try {
            constructor = clazz.getDeclaredConstructor(UUID.class, Tag.class, CompoundTag.class, Boolean.TYPE, DirectionalPosition.class, Boolean.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return RecordCodecBuilder.create(i -> i.group((App)UUIDUtil.CODEC.fieldOf("ID").forGetter(Filter::getId), (App)tagCodec.optionalFieldOf("Tag").forGetter(u -> Optional.ofNullable(u.getTag())), (App)CompoundTag.CODEC.optionalFieldOf("Metadata").forGetter(itemFilter -> Optional.ofNullable(itemFilter.getMetadata())), (App)Codec.BOOL.fieldOf("ExactMetadata").forGetter(Filter::isExactMetadata), (App)DirectionalPosition.CODEC.optionalFieldOf("Destination").forGetter(itemFilter -> Optional.ofNullable(itemFilter.getDestination())), (App)Codec.BOOL.fieldOf("Invert").forGetter(Filter::isInvert)).apply((Applicative)i, (id, tag, metadata, exactMetadata, destination, invert) -> {
            try {
                return (Filter)constructor.newInstance(id, tag.orElse(null), metadata.orElse(null), exactMetadata, destination.orElse(null), invert);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public static <T, U extends Filter<U, T>> StreamCodec<RegistryFriendlyByteBuf, U> streamCodec(Class<U> clazz, StreamCodec<RegistryFriendlyByteBuf, Tag<T>> tagCodec) {
        Constructor constructor;
        try {
            constructor = clazz.getDeclaredConstructor(UUID.class, Tag.class, CompoundTag.class, Boolean.TYPE, DirectionalPosition.class, Boolean.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Filter::getId, (StreamCodec)ByteBufCodecs.optional(tagCodec), f -> Optional.ofNullable(f.getTag()), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.COMPOUND_TAG), f -> Optional.ofNullable(f.getMetadata()), (StreamCodec)ByteBufCodecs.BOOL, Filter::isExactMetadata, (StreamCodec)ByteBufCodecs.optional(DirectionalPosition.STREAM_CODEC), f -> Optional.ofNullable(f.getDestination()), (StreamCodec)ByteBufCodecs.BOOL, Filter::isInvert, (id, tag, metadata, exactMetadata, destination, invert) -> {
            try {
                return (Filter)constructor.newInstance(id, tag.orElse(null), metadata.orElse(null), exactMetadata, destination.orElse(null), invert);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <T> Codec<Tag<T>> tagCodec(TagConverter<T> tagConverter) {
        return TAG_DATA_CODEC.xmap(data -> tagConverter.convert(data.isSingle(), data.location), tag -> {
            if (tag instanceof SingleElementTag) {
                SingleElementTag singleElementTag = (SingleElementTag)tag;
                return new TagData(TagType.SINGLE, singleElementTag.getName());
            }
            return new TagData(TagType.TAG, tag.getName());
        });
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Tag<T>> tagStreamCodec(TagConverter<T> tagConverter) {
        return TAG_DATA_STREAM_CODEC.map(data -> tagConverter.convert(data.isSingle(), data.location), tag -> {
            if (tag instanceof SingleElementTag) {
                SingleElementTag singleElementTag = (SingleElementTag)tag;
                return new TagData(TagType.SINGLE, singleElementTag.getName());
            }
            return new TagData(TagType.TAG, tag.getName());
        });
    }

    @FunctionalInterface
    public static interface TagConverter<T> {
        public Tag<T> convert(boolean var1, Identifier var2);
    }

    protected record TagData(TagType tagType, Identifier location) {
        public TagData(boolean single, Identifier location) {
            this(single ? TagType.SINGLE : TagType.TAG, location);
        }

        public boolean isSingle() {
            return this.tagType == TagType.SINGLE;
        }
    }

    protected static enum TagType {
        SINGLE,
        TAG;

    }
}

