/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.poi;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.caffeinemc.mods.lithium.common.util.Distances;
import net.caffeinemc.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import net.caffeinemc.mods.lithium.common.world.interests.PointOfInterestStorageExtended;
import net.caffeinemc.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.caffeinemc.mods.lithium.common.world.interests.iterator.NearbyPointOfInterestStream;
import net.caffeinemc.mods.lithium.common.world.interests.iterator.SinglePointOfInterestTypeFilter;
import net.caffeinemc.mods.lithium.common.world.interests.iterator.SphereChunkOrderedPoiSetSpliterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PoiManager.class})
public abstract class PoiManagerMixin
extends SectionStorage<PoiSection, PoiSection.Packed>
implements PointOfInterestStorageExtended,
RegionBasedStorageSectionExtended<PoiSection> {
    public PoiManagerMixin(SimpleRegionStorage simpleRegionStorage, Codec<PoiSection.Packed> codec, Function<PoiSection, PoiSection.Packed> function, BiFunction<PoiSection.Packed, Runnable, PoiSection> biFunction, Function<Runnable, PoiSection> function2, RegistryAccess registryAccess, ChunkIOErrorReporter chunkIOErrorReporter, LevelHeightAccessor levelHeightAccessor) {
        super(simpleRegionStorage, codec, function, biFunction, function2, registryAccess, chunkIOErrorReporter, levelHeightAccessor);
    }

    @Overwrite
    public Optional<BlockPos> getRandom(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, PoiManager.Occupancy status, BlockPos pos, int radius, RandomSource rand) {
        ArrayList<PoiRecord> list = this.withinSquareInL2Range(typePredicate, pos, radius, status);
        for (int i = list.size() - 1; i >= 0; --i) {
            PoiRecord currentPOI = list.set(rand.nextInt(i + 1), list.get(i));
            list.set(i, currentPOI);
            if (!posPredicate.test(currentPOI.getPos())) continue;
            return Optional.of(currentPOI.getPos());
        }
        return Optional.empty();
    }

    @Override
    public Collection<Pair<Holder<PoiType>, BlockPos>> lithium$getNClosestFirstWithType(Predicate<Holder<PoiType>> typeFilter, Predicate<BlockPos> posFilter, BlockPos center, int radius, PoiManager.Occupancy status, long n) {
        boolean b;
        int radiusSq = radius * radius;
        NearbyPointOfInterestStream poisInRange = new NearbyPointOfInterestStream(typeFilter, status, poiRecord -> posFilter.test(poiRecord.getPos()), center, radius, this, (pos, pos2) -> Distances.isWithinSphereRadius(pos, radiusSq, pos2), NearbyPointOfInterestStream.POINT_COMPARATOR);
        ArrayList<Pair<Holder<PoiType>, BlockPos>> collectedPois = new ArrayList<Pair<Holder<PoiType>, BlockPos>>();
        int i = 0;
        while ((long)i < n && (b = poisInRange.tryAdvance((Consumer<? super PoiRecord>)((Consumer<PoiRecord>)poi -> collectedPois.add(Pair.of((Object)poi.getPoiType(), (Object)poi.getPos())))))) {
            ++i;
        }
        return collectedPois;
    }

    @Overwrite
    public Optional<BlockPos> find(Predicate<Holder<PoiType>> predicate, Predicate<BlockPos> filter, BlockPos center, int radius, PoiManager.Occupancy status) {
        long radiusSq = (long)radius * (long)radius;
        int minChunkX = center.getX() - radius - 1 >> 4;
        int maxChunkX = center.getX() + radius + 1 >> 4;
        int minChunkZ = center.getZ() - radius - 1 >> 4;
        int maxChunkZ = center.getZ() + radius + 1 >> 4;
        int chunkX = minChunkX;
        int chunkZ = minChunkZ;
        while (chunkZ <= maxChunkZ) {
            long deltaYSqMargin;
            PoiRecord firstMatch;
            long minChunkToBlockDistanceL2Sq = Distances.getMinChunkToBlockDistanceL2Sq(center, chunkX, chunkZ);
            if (minChunkToBlockDistanceL2Sq <= radiusSq && (firstMatch = (PoiRecord)this.lithium$getFirstInRangeInChunkColumn(chunkX, chunkZ, deltaYSqMargin = radiusSq - minChunkToBlockDistanceL2Sq, center, radiusSq, (poiSection, pos, typeFilter, posPredicate, occupancy, maxDistSq) -> ((PointOfInterestSetExtended)poiSection).lithium$getFirstMatchingPoint((BlockPos)pos, maxDistSq, (Predicate<Holder<PoiType>>)typeFilter, (Predicate<BlockPos>)posPredicate, (PoiManager.Occupancy)occupancy), predicate, filter, status)) != null) {
                return Optional.of(firstMatch.getPos());
            }
            if (++chunkX <= maxChunkX) continue;
            ++chunkZ;
            chunkX = minChunkX;
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<Pair<Holder<PoiType>, BlockPos>> findClosestWithType(Predicate<Holder<PoiType>> typeFilter, BlockPos center, int radius, PoiManager.Occupancy status) {
        int radiusSq = radius * radius;
        PoiRecord closestPoi = new NearbyPointOfInterestStream(typeFilter, status, null, center, radius, this, (pos, pos2) -> Distances.isWithinSphereRadius(pos, radiusSq, pos2), NearbyPointOfInterestStream.POINT_COMPARATOR).getFirst();
        return closestPoi == null ? Optional.empty() : Optional.of(Pair.of((Object)closestPoi.getPoiType(), (Object)closestPoi.getPos()));
    }

    @Override
    public Optional<BlockPos> lithium$takeAt(Predicate<Holder<PoiType>> typeFilter, BiPredicate<Holder<PoiType>, BlockPos> biPredicate, BlockPos blockPos) {
        PoiRecord poiRecord;
        Optional poiSection = this.getOrLoad(SectionPos.asLong((BlockPos)blockPos));
        if (poiSection.isPresent() && (poiRecord = ((PointOfInterestSetExtended)poiSection.get()).lithium$getAt(blockPos)) != null && typeFilter.test((Holder<PoiType>)poiRecord.getPoiType())) {
            poiRecord.acquireTicket();
            return Optional.of(poiRecord.getPos());
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> predicate, BlockPos center, int radius, PoiManager.Occupancy status) {
        return this.findClosest(predicate, null, center, radius, status);
    }

    @Overwrite
    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> predicate, Predicate<BlockPos> posPredicate, BlockPos center, int radius, PoiManager.Occupancy status) {
        int radiusSq = radius * radius;
        PoiRecord closest = new NearbyPointOfInterestStream(predicate, status, posPredicate == null ? null : poi -> posPredicate.test(poi.getPos()), center, radius, this, (pos, pos2) -> Distances.isWithinSphereRadius(pos, radiusSq, pos2), NearbyPointOfInterestStream.POINT_COMPARATOR).getFirst();
        return closest == null ? Optional.empty() : Optional.of(closest.getPos());
    }

    @Overwrite
    public long getCountInRange(Predicate<Holder<PoiType>> predicate, BlockPos pos, int radius, PoiManager.Occupancy status) {
        return this.withinSquareInL2Range(predicate, pos, radius, status).size();
    }

    @Overwrite
    public Stream<PoiRecord> getInRange(Predicate<Holder<PoiType>> predicate, BlockPos center, int radius, PoiManager.Occupancy status) {
        return StreamSupport.stream(new SphereChunkOrderedPoiSetSpliterator(radius, center, this, predicate, status), false);
    }

    @Override
    public Optional<PoiRecord> lithium$findNearestForPortalLogic(BlockPos origin, int radius, Holder<PoiType> type, PoiManager.Occupancy status, Predicate<PoiRecord> afterSortPredicate, WorldBorder worldBorder) {
        boolean worldBorderIsFarAway = worldBorder == null || worldBorder.getDistanceToBorder((double)origin.getX(), (double)origin.getZ()) > (double)(radius + 3);
        Predicate<PoiRecord> poiPredicateAfterSorting = worldBorderIsFarAway ? afterSortPredicate : poi -> worldBorder.isWithinBounds(poi.getPos()) && afterSortPredicate.test((PoiRecord)poi);
        SinglePointOfInterestTypeFilter typePredicate = new SinglePointOfInterestTypeFilter(type);
        PoiRecord nearestPoi = new NearbyPointOfInterestStream(typePredicate, status, poiPredicateAfterSorting, origin, radius, this, (pos, pos2) -> Distances.isWithinCubeRadius(pos, radius, pos2), NearbyPointOfInterestStream.NEGATIVE_Y_POINT_COMPARATOR).getFirst();
        return nearestPoi == null ? Optional.empty() : Optional.of(nearestPoi);
    }

    @Unique
    private ArrayList<PoiRecord> withinSquareInL2Range(Predicate<Holder<PoiType>> predicate, BlockPos origin, int radius, PoiManager.Occupancy status) {
        int radiusSq = Math.multiplyExact(radius, radius);
        int minChunkX = origin.getX() - radius - 1 >> 4;
        int minChunkZ = origin.getZ() - radius - 1 >> 4;
        int maxChunkX = origin.getX() + radius + 1 >> 4;
        int maxChunkZ = origin.getZ() + radius + 1 >> 4;
        ArrayList<PoiRecord> points = new ArrayList<PoiRecord>();
        Consumer<PoiRecord> collector = point -> {
            if (Distances.isWithinSphereRadius(origin, radiusSq, point.getPos())) {
                points.add((PoiRecord)point);
            }
        };
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                for (PoiSection set : this.lithium$getInChunkColumn(x, z)) {
                    ((PointOfInterestSetExtended)set).lithium$collectMatchingPoints(predicate, status, collector);
                }
            }
        }
        return points;
    }
}

