/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.pathing;

import net.caffeinemc.mods.lithium.common.util.Pos;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PathNavigationRegion.class})
public abstract class PathNavigationRegionMixin
implements BlockGetter {
    private static final BlockState DEFAULT_BLOCK = Blocks.AIR.defaultBlockState();
    @Shadow
    @Final
    protected ChunkAccess[][] chunks;
    @Shadow
    @Final
    protected int centerX;
    @Shadow
    @Final
    protected int centerZ;
    @Shadow
    @Final
    protected Level level;
    private ChunkAccess[] chunksFlat;
    private int xLen;
    private int zLen;
    private int bottomY;
    private int topY;

    @Shadow
    public abstract int getMinY();

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="RETURN")})
    private void init(Level world, BlockPos minPos, BlockPos maxPos, CallbackInfo ci) {
        this.xLen = 1 + Pos.ChunkCoord.fromBlockCoord(maxPos.getX()) - Pos.ChunkCoord.fromBlockCoord(minPos.getX());
        this.zLen = 1 + Pos.ChunkCoord.fromBlockCoord(maxPos.getZ()) - Pos.ChunkCoord.fromBlockCoord(minPos.getZ());
        this.chunksFlat = new ChunkAccess[this.xLen * this.zLen];
        for (int x = 0; x < this.xLen; ++x) {
            System.arraycopy(this.chunks[x], 0, this.chunksFlat, x * this.zLen, this.zLen);
        }
        this.bottomY = this.getMinY();
        this.topY = this.getMaxY();
    }

    @Overwrite
    public BlockState getBlockState(BlockPos pos) {
        int y = pos.getY();
        if (y >= this.bottomY && y <= this.topY) {
            LevelChunkSection section;
            ChunkAccess chunk;
            int x = pos.getX();
            int z = pos.getZ();
            int chunkX = Pos.ChunkCoord.fromBlockCoord(x) - this.centerX;
            int chunkZ = Pos.ChunkCoord.fromBlockCoord(z) - this.centerZ;
            if (chunkX >= 0 && chunkX < this.xLen && chunkZ >= 0 && chunkZ < this.zLen && (chunk = this.chunksFlat[chunkX * this.zLen + chunkZ]) != null && (section = chunk.getSections()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)this, y)]) != null) {
                return section.getBlockState(x & 0xF, y & 0xF, z & 0xF);
            }
        }
        return DEFAULT_BLOCK;
    }

    @Overwrite
    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }
}

