/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.tracking.block;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.util.ArrayList;
import net.caffeinemc.mods.lithium.common.block.BlockListeningSection;
import net.caffeinemc.mods.lithium.common.tracking.block.BlockChangeTracker;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.world.LithiumData;
import net.caffeinemc.mods.lithium.common.world.chunk.ChunkStatusTracker;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;

public final class ChunkSectionChangeCallback {
    private final long sectionPos;
    private ArrayList<BlockChangeTracker> trackers;

    public static void init() {
        if (BlockListeningSection.class.isAssignableFrom(LevelChunkSection.class)) {
            ChunkStatusTracker.registerUnloadCallback((serverWorld, chunkPos) -> {
                Long2ReferenceOpenHashMap<ChunkSectionChangeCallback> changeCallbacks = ((LithiumData)serverWorld).lithium$getData().chunkSectionChangeCallbacks();
                int x = chunkPos.x;
                int z = chunkPos.z;
                for (int y = Pos.SectionYCoord.getMinYSection((LevelHeightAccessor)serverWorld); y <= Pos.SectionYCoord.getMaxYSectionInclusive((LevelHeightAccessor)serverWorld); ++y) {
                    SectionPos chunkSectionPos = SectionPos.of((int)x, (int)y, (int)z);
                    ChunkSectionChangeCallback chunkSectionChangeCallback = (ChunkSectionChangeCallback)changeCallbacks.remove(chunkSectionPos.asLong());
                    if (chunkSectionChangeCallback == null) continue;
                    chunkSectionChangeCallback.onChunkSectionInvalidated(chunkSectionPos);
                }
            });
        }
    }

    public ChunkSectionChangeCallback(long sectionPos) {
        this.sectionPos = sectionPos;
    }

    public static ChunkSectionChangeCallback create(long sectionPos, Level world) {
        ChunkSectionChangeCallback chunkSectionChangeCallback = new ChunkSectionChangeCallback(sectionPos);
        Long2ReferenceOpenHashMap<ChunkSectionChangeCallback> changeCallbacks = ((LithiumData)world).lithium$getData().chunkSectionChangeCallbacks();
        ChunkSectionChangeCallback previous = (ChunkSectionChangeCallback)changeCallbacks.put(sectionPos, (Object)chunkSectionChangeCallback);
        if (previous != null) {
            previous.onChunkSectionInvalidated(SectionPos.of((long)sectionPos));
        }
        return chunkSectionChangeCallback;
    }

    public void onBlockChange(BlockListeningSection section, int localX, int localY, int localZ, BlockState oldState, BlockState newState) {
        ArrayList<BlockChangeTracker> blockChangeTrackers = this.trackers;
        this.trackers = null;
        if (blockChangeTrackers != null) {
            for (int i = blockChangeTrackers.size() - 1; i >= 0; --i) {
                BlockChangeTracker tracker = blockChangeTrackers.get(i);
                if (tracker.setChanged(section, localX, localY, localZ, oldState, newState)) continue;
                BlockChangeTracker swap = blockChangeTrackers.removeLast();
                if (i == blockChangeTrackers.size()) continue;
                blockChangeTrackers.set(i, swap);
            }
            if (this.trackers != null) {
                blockChangeTrackers.addAll(this.trackers);
            }
            if (!blockChangeTrackers.isEmpty()) {
                this.trackers = blockChangeTrackers;
            }
        }
    }

    public void addTracker(BlockChangeTracker tracker) {
        ArrayList<BlockChangeTracker> blockChangeTrackers = this.trackers;
        if (blockChangeTrackers == null) {
            this.trackers = blockChangeTrackers = new ArrayList();
        }
        blockChangeTrackers.add(tracker);
    }

    public void removeTracker(BlockChangeTracker tracker) {
        ArrayList<BlockChangeTracker> blockChangeTrackers = this.trackers;
        if (blockChangeTrackers != null) {
            blockChangeTrackers.remove(tracker);
        }
    }

    public void onChunkSectionInvalidated(SectionPos sectionPos) {
        ArrayList<BlockChangeTracker> blockChangeTrackers = this.trackers;
        this.trackers = null;
        if (blockChangeTrackers != null) {
            for (int i = 0; i < blockChangeTrackers.size(); ++i) {
                blockChangeTrackers.get(i).onChunkSectionInvalidated(sectionPos);
            }
        }
    }

    public long getSectionPos() {
        return this.sectionPos;
    }

    public int getX(int localX) {
        return SectionPos.sectionToBlockCoord((int)SectionPos.x((long)this.sectionPos)) + localX;
    }

    public int getY(int localY) {
        return SectionPos.sectionToBlockCoord((int)SectionPos.y((long)this.sectionPos)) + localY;
    }

    public int getZ(int localZ) {
        return SectionPos.sectionToBlockCoord((int)SectionPos.z((long)this.sectionPos)) + localZ;
    }
}

