/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.components.NamedPositions;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.SentryRemoteAccessToolItem;
import net.geforcemods.securitycraft.network.server.RemoveSentryFromSRAT;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class SentryRemoteAccessToolScreen
extends Screen {
    private static final Identifier TEXTURE = SecurityCraft.resLoc("textures/gui/container/srat.png");
    private static final Identifier CAMOUFLAGE_SPRITE = SecurityCraft.resLoc("sentry/camouflage");
    private static final Identifier AGGRESSIVE_SPRITE = SecurityCraft.resLoc("sentry/aggressive");
    private static final Identifier IDLE_SPRITE = SecurityCraft.resLoc("sentry/idle");
    private static final Identifier ATTACK_HOSTILE_AND_PLAYERS_SPRITE = SecurityCraft.resLoc("sentry/attack_hostile_and_players");
    private static final Identifier ATTACK_HOSTILE_SPRITE = SecurityCraft.resLoc("sentry/attack_hostile");
    private static final Identifier ATTACK_PLAYERS_SPRITE = SecurityCraft.resLoc("sentry/attack_players");
    private final Component modifyAll = Utils.localize("gui.securitycraft:srat.modifyAll", new Object[0]);
    private ItemStack srat;
    private Button[][] guiButtons = new Button[12][3];
    private Button[] guiButtonsGlobal = new Button[3];
    private static final int MODE = 0;
    private static final int TARGETS = 1;
    private static final int UNBIND = 2;
    private int xSize = 440;
    private int ySize = 215;
    private int leftPos;
    private int topPos;
    private List<TextHoverChecker> hoverCheckers = new ArrayList<TextHoverChecker>();
    private final Component notBound = Utils.localize("gui.securitycraft:srat.notBound", new Object[0]);
    private final Component[] lines = new Component[12];
    private final int[] lengths = new int[12];

    public SentryRemoteAccessToolScreen(ItemStack item) {
        super(item.getHoverName());
        this.srat = item;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.xSize) / 2;
        this.topPos = (this.height - this.ySize) / 2;
        int startX = (this.width - this.xSize) / 2;
        int startY = (this.height - this.ySize) / 2;
        int paddingX = 22;
        int paddingY = 50;
        int id = 0;
        boolean foundSentry = false;
        this.hoverCheckers.clear();
        for (int i = 0; i < 12; ++i) {
            int x = i / 6 * this.xSize / 2;
            int y = (i % 6 + 1) * 25 + paddingY;
            int btnY = startY + y - 48;
            for (int j = 0; j < 3; ++j) {
                int btnX = startX + j * paddingX + 147 + x;
                int sentry = id / 3;
                int type = id % 3;
                int index = id++;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new TogglePictureButton(btnX, btnY, 20, 20, 2, 16, 16, 3, b -> this.buttonClicked(b, sentry, type), CAMOUFLAGE_SPRITE, AGGRESSIVE_SPRITE, IDLE_SPRITE);
                        this.guiButtons[i][j].active = false;
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new TogglePictureButton(btnX, btnY, 20, 20, 2, 16, 16, 3, b -> this.buttonClicked(b, sentry, type), ATTACK_HOSTILE_AND_PLAYERS_SPRITE, ATTACK_HOSTILE_SPRITE, ATTACK_PLAYERS_SPRITE);
                        this.guiButtons[i][j].active = false;
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = Button.builder((Component)Component.literal((String)"X"), b -> this.unbindButtonClicked(index)).pos(btnX, btnY).size(20, 20).build();
                        this.guiButtons[i][j].active = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Sentry actions can only range from 0-2 (inclusive)");
                    }
                }
                this.addRenderableWidget((GuiEventListener)this.guiButtons[i][j]);
            }
            NamedPositions.Entry entry = this.getSentryEntry(i);
            if (entry != null) {
                Sentry sentry;
                List sentries;
                GlobalPos globalPos = entry.globalPos();
                BlockPos sentryPos = globalPos.pos();
                ClientLevel level = this.minecraft.level;
                MutableComponent sentryName = null;
                if (entry.name().isPresent()) {
                    sentryName = Component.literal((String)entry.name().get());
                }
                this.lines[i] = Utils.getFormattedCoordinates(sentryPos);
                this.guiButtons[i][2].active = true;
                if (globalPos.dimension().equals(level.dimension()) && level.isLoaded(sentryPos) && !(sentries = level.getEntitiesOfClass(Sentry.class, new AABB(sentryPos))).isEmpty() && (sentry = (Sentry)sentries.get(0)).isOwnedBy((Entity)this.minecraft.player)) {
                    Sentry.SentryMode mode = sentry.getMode();
                    if (sentryName == null && sentry.hasCustomName()) {
                        sentryName = sentry.getCustomName();
                    }
                    this.guiButtons[i][0].active = true;
                    this.guiButtons[i][1].active = mode != Sentry.SentryMode.IDLE;
                    this.guiButtons[i][2].active = true;
                    ((TogglePictureButton)this.guiButtons[i][0]).setCurrentIndex(mode.ordinal() / 3);
                    ((TogglePictureButton)this.guiButtons[i][1]).setCurrentIndex(mode.ordinal() % 3);
                    this.updateModeButtonTooltip(this.guiButtons[i][0]);
                    this.updateTargetsButtonTooltip(this.guiButtons[i][1]);
                    this.guiButtons[i][2].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                    foundSentry = true;
                }
                if (sentryName != null) {
                    int nameWidth = this.font.width((FormattedText)sentryName);
                    int nameX = startX + this.xSize / 4 - nameWidth + 33 + i / 6 * this.xSize / 2;
                    TextHoverChecker posTooltipText = new TextHoverChecker(btnY, btnY + 20, nameX, nameX + nameWidth + 2, this.lines[i]);
                    this.lines[i] = sentryName;
                    this.hoverCheckers.add(posTooltipText);
                }
                if (!foundSentry) {
                    for (int j = 0; j < 2; ++j) {
                        this.guiButtons[i][j].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:srat.outOfRange", new Object[0])));
                    }
                    this.guiButtons[i][2].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                }
            } else {
                this.lines[i] = this.notBound;
            }
            this.lengths[i] = this.font.width((FormattedText)this.lines[i]);
        }
        this.guiButtonsGlobal[0] = new TogglePictureButton(startX + 260, startY + 188, 20, 20, 2, 16, 16, 3, this::globalModeButtonClicked, CAMOUFLAGE_SPRITE, AGGRESSIVE_SPRITE, IDLE_SPRITE);
        this.guiButtonsGlobal[1] = new TogglePictureButton(startX + 22 + 260, startY + 188, 20, 20, 2, 16, 16, 3, this::globalTargetsButtonClicked, ATTACK_HOSTILE_AND_PLAYERS_SPRITE, ATTACK_HOSTILE_SPRITE, ATTACK_PLAYERS_SPRITE);
        this.guiButtonsGlobal[2] = Button.builder((Component)Component.literal((String)"X"), this::globalUnbindButtonClicked).pos(startX + 44 + 260, startY + 188).size(20, 20).build();
        for (int j = 0; j < 3; ++j) {
            this.guiButtonsGlobal[j].active = foundSentry;
            this.addRenderableWidget((GuiEventListener)this.guiButtonsGlobal[j]);
        }
        this.updateModeButtonTooltip(this.guiButtonsGlobal[0]);
        this.updateTargetsButtonTooltip(this.guiButtonsGlobal[1]);
        this.guiButtonsGlobal[2].setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.xSize / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, -12566464, false);
        for (int i = 0; i < 12; ++i) {
            guiGraphics.drawString(this.font, this.lines[i], this.leftPos + this.xSize / 4 - this.lengths[i] + 35 + i / 6 * this.xSize / 2, this.topPos + i % 6 * 25 + 33, -12566464, false);
        }
        guiGraphics.drawString(this.font, this.modifyAll, this.leftPos + this.xSize / 2 - this.font.width((FormattedText)this.modifyAll) + 25, this.topPos + 194, -12566464, false);
        for (TextHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
            guiGraphics.setTooltipForNextFrame(this.font, chc.getName(), mouseX, mouseY);
            break;
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.xSize, this.ySize, 512, 256);
    }

    protected SetSentryMode.Info performSingleAction(int sentry, int mode, int targets) {
        List sentries;
        NamedPositions.Entry entry = this.getSentryEntry(sentry);
        if (entry != null && entry.globalPos() != null && !(sentries = Minecraft.getInstance().player.level().getEntitiesOfClass(Sentry.class, new AABB(entry.globalPos().pos()))).isEmpty()) {
            int resultingMode = Math.clamp((long)(targets + mode * 3), 0, 6);
            this.guiButtons[sentry][1].active = Sentry.SentryMode.values()[resultingMode] != Sentry.SentryMode.IDLE;
            ((Sentry)sentries.get(0)).toggleMode((Player)Minecraft.getInstance().player, resultingMode, false);
            this.updateModeButtonTooltip(this.guiButtons[sentry][0]);
            this.updateTargetsButtonTooltip(this.guiButtons[sentry][1]);
            return new SetSentryMode.Info(((Sentry)sentries.get(0)).blockPosition(), resultingMode);
        }
        return null;
    }

    private void unbindButtonClicked(int id) {
        this.unbindSentry(id / 3);
    }

    private void globalUnbindButtonClicked(Button button) {
        for (int i = 0; i < 12; ++i) {
            this.unbindSentry(i);
        }
    }

    private void unbindSentry(int sentry) {
        int i;
        NamedPositions.Entry entry = this.getSentryEntry(sentry);
        if (entry != null && entry.globalPos() != null) {
            this.removeTagFromToolAndUpdate(this.srat, entry.globalPos());
        }
        for (i = 0; i < 3; ++i) {
            this.guiButtons[sentry][i].active = false;
            this.guiButtons[sentry][i].setTooltip(null);
        }
        for (i = 0; i < this.guiButtons.length; ++i) {
            if (!this.guiButtons[i][2].active) continue;
            return;
        }
        for (i = 0; i < 3; ++i) {
            this.guiButtonsGlobal[i].active = false;
            this.guiButtonsGlobal[i].setTooltip(null);
        }
    }

    private void buttonClicked(Button button, int sentry, int type) {
        int mode;
        int targets = mode = ((TogglePictureButton)button).getCurrentIndex();
        if (type == 0) {
            targets = ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
        } else if (type == 1) {
            mode = ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
        }
        this.sendUpdates(Arrays.asList(this.performSingleAction(sentry, mode, targets)));
    }

    protected void globalModeButtonClicked(Button button) {
        ArrayList<SetSentryMode.Info> sentriesToUpdate = new ArrayList<SetSentryMode.Info>();
        for (int i = 0; i < this.guiButtons.length; ++i) {
            TogglePictureButton modeButton = (TogglePictureButton)this.guiButtons[i][0];
            if (this.getSentryEntry(i) == null) continue;
            int sentry = i;
            int mode = ((TogglePictureButton)button).getCurrentIndex();
            int targets = ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
            modeButton.setCurrentIndex(mode);
            sentriesToUpdate.add(this.performSingleAction(sentry, mode, targets));
        }
        this.sendUpdates(sentriesToUpdate);
        this.updateModeButtonTooltip(this.guiButtonsGlobal[0]);
    }

    protected void globalTargetsButtonClicked(Button button) {
        ArrayList<SetSentryMode.Info> sentriesToUpdate = new ArrayList<SetSentryMode.Info>();
        for (int i = 0; i < this.guiButtons.length; ++i) {
            TogglePictureButton targetsButton = (TogglePictureButton)this.guiButtons[i][1];
            if (this.getSentryEntry(i) == null) continue;
            int sentry = i;
            int mode = ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
            int targets = ((TogglePictureButton)button).getCurrentIndex();
            targetsButton.setCurrentIndex(targets);
            sentriesToUpdate.add(this.performSingleAction(sentry, mode, targets));
        }
        this.sendUpdates(sentriesToUpdate);
        this.updateTargetsButtonTooltip(this.guiButtonsGlobal[1]);
    }

    private void sendUpdates(List<SetSentryMode.Info> sentriesToUpdate) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetSentryMode(sentriesToUpdate), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private NamedPositions.Entry getSentryEntry(int sentry) {
        NamedPositions positions;
        if (this.srat.getItem() == SCContent.SENTRY_REMOTE_ACCESS_TOOL.get() && (positions = (NamedPositions)this.srat.get(SCContent.BOUND_SENTRIES)) != null && sentry >= 0 && sentry < 12) {
            return positions.positions().get(sentry);
        }
        return null;
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, GlobalPos pos) {
        ((NamedPositions)stack.getOrDefault(SCContent.BOUND_SENTRIES, (Object)SentryRemoteAccessToolItem.DEFAULT_NAMED_POSITIONS)).remove(SCContent.BOUND_SENTRIES, stack, pos);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new RemoveSentryFromSRAT(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void updateModeButtonTooltip(Button button) {
        button.setTooltip(Tooltip.create((Component)(switch (((IToggleableButton)button).getCurrentIndex()) {
            case 0 -> Utils.localize("gui.securitycraft:srat.mode2", new Object[0]);
            case 1 -> Utils.localize("gui.securitycraft:srat.mode1", new Object[0]);
            case 2 -> Utils.localize("gui.securitycraft:srat.mode3", new Object[0]);
            default -> Utils.localize("gui.securitycraft:srat.mode2", new Object[0]);
        })));
    }

    private void updateTargetsButtonTooltip(Button button) {
        button.setTooltip(Tooltip.create((Component)(switch (((IToggleableButton)button).getCurrentIndex()) {
            case 0 -> Utils.localize("gui.securitycraft:srat.targets1", new Object[0]);
            case 1 -> Utils.localize("gui.securitycraft:srat.targets2", new Object[0]);
            case 2 -> Utils.localize("gui.securitycraft:srat.targets3", new Object[0]);
            default -> Utils.localize("gui.securitycraft:srat.targets1", new Object[0]);
        })));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((KeyEvent)event))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }
}

