/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.renderers.state.SecurityCameraRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3fc;

public record SecurityCameraSpecialRenderer(SecurityCameraModel model, Identifier texture, float rotation, Optional<Integer> lensColor, Optional<Integer> light) implements NoDataSpecialModelRenderer
{
    public void submit(ItemDisplayContext ctx, PoseStack pose, SubmitNodeCollector collector, int packedLight, int packedOverlay, boolean glint, int outlineColor) {
        SecurityCameraRenderState state = new SecurityCameraRenderState();
        this.lensColor.ifPresentOrElse(color -> {
            state.hasLens = true;
            state.lensColor = color;
        }, () -> {
            state.lensColor = 0x70FFFF;
        });
        state.cameraYRot = this.rotation;
        collector.submitModel((Model)this.model, (Object)state, pose, RenderTypes.entitySolid((Identifier)this.texture), this.light.orElse(packedLight).intValue(), packedOverlay, outlineColor, null);
    }

    public void getExtents(Consumer<Vector3fc> extents) {
        PoseStack poseStack = new PoseStack();
        this.model.rotateCameraY(this.rotation);
        this.model.root().getExtentsForGui(poseStack, extents);
    }

    public record Unbaked(Identifier texture, float rotation, Optional<Integer> lensColor, Optional<Integer> light) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Identifier.CODEC.fieldOf("texture").forGetter(Unbaked::texture), (App)Codec.FLOAT.optionalFieldOf("rotation", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::rotation), (App)ExtraCodecs.RGB_COLOR_CODEC.optionalFieldOf("lens_color").forGetter(Unbaked::lensColor), (App)Codec.INT.optionalFieldOf("light").forGetter(Unbaked::light)).apply((Applicative)i, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext ctx) {
            SecurityCameraModel model = new SecurityCameraModel(ctx.entityModelSet().bakeLayer(ClientHandler.SECURITY_CAMERA_LOCATION));
            return new SecurityCameraSpecialRenderer(model, this.texture.withPrefix("textures/entity/security_camera/").withSuffix(".png"), this.rotation, this.lensColor, this.light);
        }
    }
}

