/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.ReinforcedPistonMovingBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonHeadBlock;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.PistonHeadRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.blockentity.state.PistonHeadRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ReinforcedPistonHeadRenderer
implements BlockEntityRenderer<ReinforcedPistonMovingBlockEntity, PistonHeadRenderState> {
    public ReinforcedPistonHeadRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void submit(PistonHeadRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        if (state.block != null) {
            pose.pushPose();
            pose.translate(state.xOffset, state.yOffset, state.zOffset);
            collector.submitMovingBlock(pose, state.block);
            pose.popPose();
            if (state.base != null) {
                collector.submitMovingBlock(pose, state.base);
            }
        }
    }

    public PistonHeadRenderState createRenderState() {
        return new PistonHeadRenderState();
    }

    public void extractRenderState(ReinforcedPistonMovingBlockEntity be, PistonHeadRenderState renderState, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        renderState.xOffset = be.getOffsetX(partialTick);
        renderState.yOffset = be.getOffsetY(partialTick);
        renderState.zOffset = be.getOffsetZ(partialTick);
        renderState.block = null;
        renderState.base = null;
        BlockState state = be.getMovedState();
        Level level = be.getLevel();
        if (level != null && !state.isAir()) {
            BlockPos oppositePos = be.getBlockPos().relative(be.getMovementDirection().getOpposite());
            Holder biome = level.getBiome(oppositePos);
            if (state.is((Block)SCContent.REINFORCED_PISTON_HEAD.get()) && be.getProgress(partialTick) <= 4.0f) {
                state = (BlockState)state.setValue((Property)PistonHeadBlock.SHORT, (Comparable)Boolean.valueOf(be.getProgress(partialTick) <= 0.5f));
                renderState.block = PistonHeadRenderer.createMovingBlock((BlockPos)oppositePos, (BlockState)state, (Holder)biome, (Level)level);
            } else if (be.isSourcePiston() && !be.isExtending()) {
                PistonType pistonType = state.is((Block)SCContent.REINFORCED_STICKY_PISTON.get()) ? PistonType.STICKY : PistonType.DEFAULT;
                BlockState headState = (BlockState)((BlockState)((ReinforcedPistonHeadBlock)SCContent.REINFORCED_PISTON_HEAD.get()).defaultBlockState().setValue((Property)PistonHeadBlock.TYPE, (Comparable)pistonType)).setValue((Property)DirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)DirectionalBlock.FACING)));
                BlockPos renderPos = oppositePos.relative(be.getMovementDirection());
                headState = (BlockState)headState.setValue((Property)PistonHeadBlock.SHORT, (Comparable)Boolean.valueOf(be.getProgress(partialTick) >= 0.5f));
                renderState.block = PistonHeadRenderer.createMovingBlock((BlockPos)oppositePos, (BlockState)headState, (Holder)biome, (Level)level);
                state = (BlockState)state.setValue((Property)PistonBaseBlock.EXTENDED, (Comparable)Boolean.valueOf(true));
                renderState.base = PistonHeadRenderer.createMovingBlock((BlockPos)renderPos, (BlockState)state, (Holder)biome, (Level)level);
            } else {
                renderState.block = PistonHeadRenderer.createMovingBlock((BlockPos)oppositePos, (BlockState)state, (Holder)biome, (Level)level);
            }
        }
    }

    public int getViewDistance() {
        return 68;
    }

    public AABB getRenderBoundingBox(ReinforcedPistonMovingBlockEntity be) {
        return AABB.INFINITE;
    }
}

