/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.entity.camera.CameraFeed;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.renderers.state.FrameRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class FrameBlockEntityRenderer
implements BlockEntityRenderer<FrameBlockEntity, FrameRenderState> {
    private static final Identifier CAMERA_NOT_FOUND = SecurityCraft.resLoc("textures/entity/frame/camera_not_found.png");
    private static final Identifier INACTIVE = SecurityCraft.resLoc("textures/entity/frame/inactive.png");
    private static final Identifier NO_REDSTONE_SIGNAL = SecurityCraft.resLoc("textures/entity/frame/no_redstone_signal.png");
    private static final Material NOISE_BACKGROUND = new Material(TextureAtlas.LOCATION_BLOCKS, SecurityCraft.resLoc("entity/frame/noise_background"));
    private static final Identifier SELECT_CAMERA = SecurityCraft.resLoc("textures/entity/frame/select_camera.png");
    private static final Identifier WHITE = SecurityCraft.resLoc("textures/entity/frame/white.png");
    public static final RenderPipeline FRAME_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.MATRICES_PROJECTION_SNIPPET}).withLocation(SecurityCraft.resLoc("pipeline/frame_draw_fb_in_area")).withVertexShader(SecurityCraft.resLoc("frame_draw_fb_in_area")).withFragmentShader(SecurityCraft.resLoc("frame_draw_fb_in_area")).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("InSampler").withBlend(BlendFunction.TRANSLUCENT).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();

    public FrameBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void submit(FrameRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        if (state.isDisabled || !state.canSeeFeed || !state.hasCamerasLinked) {
            return;
        }
        float margin = 0.0625f;
        Vector4f innerVertices = state.innerVertices;
        Vector4f outerVertices = state.outerVertices;
        Vec3i normal = state.normal;
        int lightCoords = state.lightCoords;
        if (!state.isCameraSelected) {
            this.submitSolidTexture(pose, collector, SELECT_CAMERA, innerVertices, lightCoords, normal, 0.0625f);
        } else if (state.isRedstoneSignalDisabled) {
            this.submitNoise(pose, collector, state.innerVertices, lightCoords, normal, 0.0625f);
            this.submitCutoutTexture(pose, collector, NO_REDSTONE_SIGNAL, outerVertices, lightCoords, normal, 0.0625f);
        } else if (!state.hasClientInteracted) {
            this.submitNoise(pose, collector, innerVertices, lightCoords, normal, 0.0625f);
            this.submitCutoutTexture(pose, collector, INACTIVE, outerVertices, lightCoords, normal, 0.0625f);
        } else if (!state.isCameraPresent) {
            this.submitSolidTexture(pose, collector, CAMERA_NOT_FOUND, innerVertices, lightCoords, normal, 0.0625f);
        } else if (!FrameFeedHandler.isCapturingCamera()) {
            Vector3f backgroundColor = state.backgroundColor;
            float xStart = innerVertices.x;
            float xEnd = innerVertices.y;
            float zStart = innerVertices.z;
            float zEnd = innerVertices.w;
            float xStartO = outerVertices.x;
            float xEndO = outerVertices.y;
            float zStartO = outerVertices.z;
            float zEndO = outerVertices.w;
            this.submitOverlay(pose, collector, RenderTypes.entityShadow((Identifier)WHITE), ARGB.colorFromFloat((float)1.0f, (float)backgroundColor.x, (float)backgroundColor.y, (float)backgroundColor.z), xStart, xEnd, zStart, zEnd, 0.0625f, lightCoords, normal);
            try (ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(DefaultVertexFormat.POSITION_TEX.getVertexSize() * 4);){
                BufferBuilder bufferBuilder = new BufferBuilder(byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferBuilder.addVertex((Matrix4fc)pose.last().pose(), xStartO, 0.0625f, zStartO).setUv(1.0f, 0.0f);
                bufferBuilder.addVertex((Matrix4fc)pose.last().pose(), xStartO, 0.9375f, zStartO).setUv(1.0f, 1.0f);
                bufferBuilder.addVertex((Matrix4fc)pose.last().pose(), xEndO, 0.9375f, zEndO).setUv(0.0f, 1.0f);
                bufferBuilder.addVertex((Matrix4fc)pose.last().pose(), xEndO, 0.0625f, zEndO).setUv(0.0f, 0.0f);
                try (MeshData meshData = bufferBuilder.buildOrThrow();){
                    meshData.sortQuads(byteBufferBuilder, VertexSorting.DISTANCE_TO_ORIGIN);
                    GpuDevice device = RenderSystem.getDevice();
                    GpuBuffer vertexBuffer = device.createBuffer(() -> "Frame Vertex", 32, meshData.vertexBuffer());
                    GpuBuffer indexBuffer = device.createBuffer(() -> "Frame Index", 72, meshData.indexBuffer());
                    RenderTarget mainRenderTarget = Minecraft.getInstance().getMainRenderTarget();
                    GpuBufferSlice dynamicTransforms = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f());
                    try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "SC camera frame at " + String.valueOf(state.blockPos), mainRenderTarget.getColorTextureView(), OptionalInt.empty(), mainRenderTarget.getDepthTextureView(), OptionalDouble.empty());){
                        RenderSystem.bindDefaultUniforms((RenderPass)pass);
                        pass.setPipeline(FRAME_PIPELINE);
                        pass.setVertexBuffer(0, vertexBuffer);
                        pass.setIndexBuffer(indexBuffer, meshData.drawState().indexType());
                        pass.setUniform("DynamicTransforms", dynamicTransforms);
                        pass.bindTexture("InSampler", state.renderTargetColorTexture, RenderSystem.getSamplerCache().getClampToEdge(FilterMode.NEAREST));
                        pass.drawIndexed(0, 0, 6, 1);
                    }
                    vertexBuffer.close();
                    indexBuffer.close();
                }
            }
            if (state.hasLens) {
                this.submitOverlay(pose, collector, state.lensColor, xStartO, xEndO, zStartO, zEndO, 0.0625f, lightCoords, normal);
            }
        }
    }

    public FrameRenderState createRenderState() {
        return new FrameRenderState();
    }

    public void extractRenderState(FrameBlockEntity be, FrameRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        LocalPlayer player = Minecraft.getInstance().player;
        Level level = be.getLevel();
        GlobalPos securityCameraPos = be.getCurrentCamera();
        Direction direction = (Direction)be.getBlockState().getValue(FrameBlock.FACING);
        float margin = 0.0625f;
        switch (direction) {
            case NORTH: {
                state.innerVertices = new Vector4f(0.0625f, 0.9375f, 0.05f, 0.05f);
                state.outerVertices = new Vector4f(0.0625f, 0.9375f, 0.045f, 0.045f);
                break;
            }
            case SOUTH: {
                state.innerVertices = new Vector4f(0.9375f, 0.0625f, 0.95f, 0.95f);
                state.outerVertices = new Vector4f(0.9375f, 0.0625f, 0.955f, 0.955f);
                break;
            }
            case WEST: {
                state.innerVertices = new Vector4f(0.05f, 0.05f, 0.9375f, 0.0625f);
                state.outerVertices = new Vector4f(0.045f, 0.045f, 0.9375f, 0.0625f);
                break;
            }
            case EAST: {
                state.innerVertices = new Vector4f(0.95f, 0.95f, 0.0625f, 0.9375f);
                state.outerVertices = new Vector4f(0.955f, 0.955f, 0.0625f, 0.9375f);
                break;
            }
            default: {
                state.innerVertices = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
                state.outerVertices = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
            }
        }
        state.normal = direction.getUnitVec3i();
        state.isDisabled = be.isDisabled();
        state.canSeeFeed = be.isOwnedBy((Entity)player) || be.isAllowed((Entity)player);
        state.hasCamerasLinked = !be.getCameraPositions().isEmpty();
        state.isCameraSelected = securityCameraPos != null;
        state.isRedstoneSignalDisabled = be.redstoneSignalDisabled();
        state.hasClientInteracted = be.hasClientInteracted();
        if (state.isCameraSelected) {
            BlockEntity blockEntity;
            CameraFeed feed = FrameFeedHandler.getFeed(securityCameraPos);
            if (feed != null && feed.isFrameLinked(be) && level.isLoaded(securityCameraPos.pos()) && (blockEntity = level.getBlockEntity(securityCameraPos.pos())) instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity cameraBlockEntity = (SecurityCameraBlockEntity)blockEntity;
                state.isCameraPresent = true;
                state.renderTargetColorTexture = feed.renderTarget().getColorTextureView();
                state.backgroundColor = feed.backgroundColor();
                ItemStack lens = cameraBlockEntity.getLensContainer().getItem(0);
                if (lens.has(DataComponents.DYED_COLOR)) {
                    state.hasLens = true;
                    state.lensColor = ARGB.color((int)cameraBlockEntity.getOpacity(), (int)((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb());
                } else {
                    state.hasLens = false;
                }
            } else {
                state.isCameraPresent = false;
            }
        }
    }

    private void submitNoise(PoseStack poseStack, SubmitNodeCollector collector, Vector4f vertices, final int packedLight, Vec3i normal, final float margin) {
        final PoseStack.Pose last = poseStack.last();
        final float xStart = vertices.x;
        final float xEnd = vertices.y;
        final float zStart = vertices.z - 1.0E-4f;
        final float zEnd = vertices.w;
        final int nx = normal.getX();
        final int ny = normal.getY();
        final int nz = normal.getZ();
        collector.submitCustomGeometry(poseStack, RenderTypes.entitySolid((Identifier)NOISE_BACKGROUND.texture()), (SubmitNodeCollector.CustomGeometryRenderer)new WrappingGeometryRenderer(this, NOISE_BACKGROUND){

            public void render(PoseStack.Pose pose, VertexConsumer builder) {
                builder.addVertex(pose, xStart, margin, zStart).setUv(1.0f, 1.0f).setColor(-1).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
                builder.addVertex(pose, xStart, 1.0f - margin, zStart).setUv(1.0f, 0.0f).setColor(-1).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
                builder.addVertex(pose, xEnd, 1.0f - margin, zEnd).setUv(0.0f, 0.0f).setColor(-1).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
                builder.addVertex(pose, xEnd, margin, zEnd).setUv(0.0f, 1.0f).setColor(-1).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
            }
        });
    }

    private void submitSolidTexture(PoseStack pose, SubmitNodeCollector collector, Identifier texture, Vector4f vertices, int packedLight, Vec3i normal, float margin) {
        this.submitTexture(pose, collector, RenderTypes.entitySolid((Identifier)texture), vertices, packedLight, normal, margin);
    }

    private void submitCutoutTexture(PoseStack pose, SubmitNodeCollector collector, Identifier texture, Vector4f vertices, int packedLight, Vec3i normal, float margin) {
        this.submitTexture(pose, collector, RenderTypes.entityCutout((Identifier)texture), vertices, packedLight, normal, margin);
    }

    private void submitTexture(PoseStack poseStack, SubmitNodeCollector collector, RenderType renderType, Vector4f vertices, int packedLight, Vec3i normal, float margin) {
        PoseStack.Pose last = poseStack.last();
        float xStart = vertices.x;
        float xEnd = vertices.y;
        float zStart = vertices.z;
        float zEnd = vertices.w;
        int nx = normal.getX();
        int ny = normal.getY();
        int nz = normal.getZ();
        collector.submitCustomGeometry(poseStack, renderType, (pose, builder) -> {
            builder.addVertex(pose, xStart, margin, zStart).setUv(1.0f, 1.0f).setColor(-1).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
            builder.addVertex(pose, xStart, 1.0f - margin, zStart).setUv(1.0f, 0.0f).setColor(-1).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
            builder.addVertex(pose, xEnd, 1.0f - margin, zEnd).setUv(0.0f, 0.0f).setColor(-1).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
            builder.addVertex(pose, xEnd, margin, zEnd).setUv(0.0f, 1.0f).setColor(-1).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        });
    }

    private void submitOverlay(PoseStack pose, SubmitNodeCollector collector, int color, float xStart, float xEnd, float zStart, float zEnd, float margin, int packedLight, Vec3i normal) {
        this.submitOverlay(pose, collector, RenderTypes.entityTranslucent((Identifier)WHITE), color, xStart, xEnd, zStart, zEnd, margin, packedLight, normal);
    }

    private void submitOverlay(PoseStack poseStack, SubmitNodeCollector collector, RenderType renderType, int color, float xStart, float xEnd, float zStart, float zEnd, float margin, int packedLight, Vec3i normal) {
        int nx = normal.getX();
        int ny = normal.getY();
        int nz = normal.getZ();
        collector.submitCustomGeometry(poseStack, renderType, (pose, builder) -> {
            builder.addVertex(pose, xStart, margin, zStart).setColor(color).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)nx, (float)ny, (float)nz);
            builder.addVertex(pose, xStart, 1.0f - margin, zStart).setColor(color).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)nx, (float)ny, (float)nz);
            builder.addVertex(pose, xEnd, 1.0f - margin, zEnd).setColor(color).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)nx, (float)ny, (float)nz);
            builder.addVertex(pose, xEnd, margin, zEnd).setColor(color).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)nx, (float)ny, (float)nz);
        });
    }

    public abstract class WrappingGeometryRenderer
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public final Material material;

        public WrappingGeometryRenderer(FrameBlockEntityRenderer this$0, Material material) {
            this.material = material;
        }
    }
}

