/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.sentry.Bullet;
import net.geforcemods.securitycraft.models.BulletModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ArrowRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.Identifier;
import org.joml.Quaternionfc;

public class BulletRenderer
extends EntityRenderer<Bullet, ArrowRenderState> {
    private static final Identifier TEXTURE = SecurityCraft.resLoc("textures/entity/bullet.png");
    private final BulletModel model;

    public BulletRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new BulletModel(ctx.bakeLayer(ClientHandler.BULLET_LOCATION));
    }

    public void submit(ArrowRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot));
        collector.submitModel((Model)this.model, (Object)state, pose, RenderTypes.entitySolid((Identifier)TEXTURE), state.lightCoords, OverlayTexture.NO_OVERLAY, -1, null, state.outlineColor, null);
    }

    public ArrowRenderState createRenderState() {
        return new ArrowRenderState();
    }
}

