/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.renderers.state.BlockPocketManagerRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockPocketManagerRenderer
implements BlockEntityRenderer<BlockPocketManagerBlockEntity, BlockPocketManagerRenderState> {
    public static final int RENDER_DISTANCE = 100;

    public BlockPocketManagerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void submit(BlockPocketManagerRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState camera) {
        if (!state.showsOutline || !state.ownedByPlayer) {
            return;
        }
        BlockPos blockPos = state.blockPos;
        Vec3 cameraPos = camera.pos;
        collector.submitCustomGeometry(poseStack, RenderTypes.lines(), (pose, builder) -> ShapeRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)builder, (VoxelShape)state.shape, (double)((double)blockPos.getX() - cameraPos.x), (double)((double)blockPos.getY() - cameraPos.y), (double)((double)blockPos.getZ() - cameraPos.z), (int)state.color, (float)2.0f));
    }

    public BlockPocketManagerRenderState createRenderState() {
        return new BlockPocketManagerRenderState();
    }

    public void extractRenderState(BlockPocketManagerBlockEntity be, BlockPocketManagerRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        Direction facing = (Direction)be.getBlockState().getValue(BlockPocketManagerBlock.FACING);
        int offset = facing == Direction.NORTH || facing == Direction.EAST ? -be.getAutoBuildOffset() : be.getAutoBuildOffset();
        int size = be.getSize();
        int half = (size - 1) / 2;
        int leftX = -half + offset;
        int rightX = half + 1 + offset;
        int frontZ = facing == Direction.NORTH || facing == Direction.WEST ? 0 : 1;
        int backZ = facing == Direction.NORTH || facing == Direction.WEST ? size : 1 - size;
        int packedColor = be.getColor();
        if (facing == Direction.EAST || facing == Direction.WEST) {
            leftX = frontZ;
            rightX = backZ;
            frontZ = -half + offset;
            backZ = half + 1 + offset;
        }
        AABB aabb = new AABB((double)leftX, 0.0, (double)frontZ, (double)rightX, (double)size, (double)backZ);
        state.showsOutline = be.showsOutline();
        state.ownedByPlayer = be.isOwnedBy((Entity)Minecraft.getInstance().player);
        state.shape = Shapes.create((double)aabb.minX, (double)aabb.minY, (double)aabb.minZ, (double)aabb.maxX, (double)aabb.maxY, (double)aabb.maxZ);
        state.color = packedColor;
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public AABB getRenderBoundingBox(BlockPocketManagerBlockEntity be) {
        return new AABB(be.getBlockPos()).inflate(100.0);
    }
}

