/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncTrophySystem(BlockPos pos, Identifier projectileTypeLocation, boolean allowed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncTrophySystem> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_trophy_system"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncTrophySystem> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncTrophySystem::pos, (StreamCodec)Identifier.STREAM_CODEC, SyncTrophySystem::projectileTypeLocation, (StreamCodec)ByteBufCodecs.BOOL, SyncTrophySystem::allowed, SyncTrophySystem::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        TrophySystemBlockEntity be;
        BlockEntity blockEntity;
        EntityType projectileType = (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(this.projectileTypeLocation).orElseThrow()).value();
        Player player = ctx.player();
        Level level = player.level();
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof TrophySystemBlockEntity && (be = (TrophySystemBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            be.setFilter(projectileType, this.allowed);
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

