/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.geforcemods.securitycraft.renderers.state.SentryRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class SentryModel
extends EntityModel<SentryRenderState> {
    private final ModelPart base;
    private final List<ModelPart> headPartList;

    public SentryModel(ModelPart modelPart) {
        super(modelPart);
        this.base = modelPart.getChild("base");
        this.headPartList = List.of(modelPart.getChild("head"), modelPart.getChild("neck"), modelPart.getChild("right_eye"), modelPart.getChild("body"), modelPart.getChild("nose"), modelPart.getChild("left_eye"), modelPart.getChild("hair"));
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 15.0f, 15.0f, 15.0f), PartPose.offset((float)-7.5f, (float)9.0f, (float)-7.5f));
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 30).addBox(0.0f, 0.0f, 0.0f, 6.0f, 4.0f, 6.0f), PartPose.offset((float)-3.0f, (float)5.0f, (float)-3.0f));
        partDefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(45, 0).addBox(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)-2.0f, (float)1.0f, (float)-2.0f));
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 30).addBox(0.0f, 0.0f, 0.0f, 8.0f, 5.0f, 6.0f), PartPose.offset((float)-4.0f, (float)-4.0f, (float)-3.0f));
        partDefinition.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(0, 40).addBox(0.0f, 0.0f, 0.0f, 6.0f, 1.0f, 6.0f), PartPose.offset((float)-3.0f, (float)-5.0f, (float)-3.0f));
        partDefinition.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f), PartPose.offset((float)-2.7f, (float)-3.0f, (float)-3.3f));
        partDefinition.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(6, 0).addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f), PartPose.offset((float)0.7f, (float)-3.0f, (float)-3.3f));
        partDefinition.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 4.0f), PartPose.offset((float)-0.5f, (float)-1.0f, (float)-6.9f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void submitBase(SentryRenderState state, PoseStack pose, SubmitNodeCollector submitNodeCollector, RenderType renderType) {
        submitNodeCollector.submitModelPart(this.base, pose, renderType, state.lightCoords, OverlayTexture.NO_OVERLAY, null, -1, null);
    }

    public void submitHead(SentryRenderState state, PoseStack pose, SubmitNodeCollector submitNodeCollector, RenderType renderType) {
        this.headPartList.forEach(part -> submitNodeCollector.submitModelPart(part, pose, renderType, state.lightCoords, OverlayTexture.NO_OVERLAY, null, -1, null));
    }
}

