/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.Window;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class}, priority=1100)
public class GameRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @ModifyExpressionValue(method={"tickFov"}, at={@At(value="CONSTANT", args={"floatValue=1.0F"})})
    private float securitycraft$modifyInitialFValue(float original) {
        Entity entity = this.minecraft.getCameraEntity();
        if (entity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)entity;
            return cam.getZoomAmount();
        }
        return original;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V")})
    private void securitycraft$renderCameraTint(DeltaTracker deltaTracker, boolean renderLevel, CallbackInfo ci, @Local GuiGraphics guiGraphics) {
        if (this.minecraft.getCameraEntity() instanceof SecurityCamera) {
            ClientLevel level = this.minecraft.level;
            BlockPos pos = this.minecraft.getCameraEntity().blockPosition();
            Window window = this.minecraft.getWindow();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
                return;
            }
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
            ItemStack lens = be.getLensContainer().getItem(0);
            if (lens.has(DataComponents.DYED_COLOR)) {
                guiGraphics.fill(0, 0, window.getGuiScaledWidth(), window.getGuiScaledHeight(), ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb() + (be.getOpacity() << 24));
            }
        }
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;lerp(FFF)F")})
    private float securitycraft$disableFeedDistortion(float delta, float start, float end, Operation<Float> original) {
        if (FrameFeedHandler.isCapturingCamera()) {
            return 0.0f;
        }
        return ((Float)original.call(new Object[]{Float.valueOf(delta), Float.valueOf(start), Float.valueOf(end)})).floatValue();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;tryTakeScreenshotIfNeeded()V")})
    private void securitycraft$afterLevelRendering(DeltaTracker deltaTracker, boolean renderLevel, CallbackInfo ci) {
        FrameFeedHandler.captureFrameFeeds(deltaTracker);
    }

    @Inject(method={"pick"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$preventFramePick(float partialTicks, CallbackInfo ci) {
        if (FrameFeedHandler.isCapturingCamera()) {
            ci.cancel();
        }
    }
}

