/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.Identifier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class KeyBindings {
    private static final List<TickingKeyMapping> TICKING_KEY_MAPPINGS = new ArrayList<TickingKeyMapping>();
    private static KeyMapping.Category category;
    private static KeyMapping cameraZoomIn;
    private static KeyMapping cameraZoomOut;
    private static KeyMapping cameraEmitRedstone;
    private static KeyMapping cameraActivateNightVision;
    private static KeyMapping setDefaultViewingDirection;

    private KeyBindings() {
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        category = KeyMapping.Category.register((Identifier)SecurityCraft.resLoc("securitycraft"));
        cameraZoomIn = KeyBindings.register(event, "cameraZoomIn", 61);
        cameraZoomOut = KeyBindings.register(event, "cameraZoomOut", 45);
        cameraEmitRedstone = KeyBindings.registerTicking(event, "cameraEmitRedstone", 82, CameraController::toggleRedstone);
        cameraActivateNightVision = KeyBindings.registerTicking(event, "cameraActivateNightVision", 78, CameraController::toggleNightVision);
        setDefaultViewingDirection = KeyBindings.registerTicking(event, "setDefaultViewingDirection", 85, CameraController::setDefaultViewingDirection);
    }

    private static KeyMapping register(RegisterKeyMappingsEvent event, String name, int defaultKey) {
        SCKeyMapping keyMapping = new SCKeyMapping(name, defaultKey);
        event.register((KeyMapping)keyMapping);
        return keyMapping;
    }

    private static KeyMapping registerTicking(RegisterKeyMappingsEvent event, String name, int defaultKey, Consumer<SecurityCamera> action) {
        TickingKeyMapping keyMapping = new TickingKeyMapping(name, defaultKey, action);
        event.register((KeyMapping)keyMapping);
        TICKING_KEY_MAPPINGS.add(keyMapping);
        return keyMapping;
    }

    public static void tick(SecurityCamera cam) {
        TICKING_KEY_MAPPINGS.forEach(keyMapping -> keyMapping.tick(cam));
    }

    public static KeyMapping cameraZoomIn() {
        return cameraZoomIn;
    }

    public static KeyMapping cameraZoomOut() {
        return cameraZoomOut;
    }

    public static KeyMapping cameraEmitRedstone() {
        return cameraEmitRedstone;
    }

    public static KeyMapping cameraActivateNightVision() {
        return cameraActivateNightVision;
    }

    public static KeyMapping setDefaultViewingDirection() {
        return setDefaultViewingDirection;
    }

    private static class SCKeyMapping
    extends KeyMapping {
        public SCKeyMapping(String name, int defaultKey) {
            super("key.securitycraft." + name, defaultKey, category);
        }
    }

    private static class TickingKeyMapping
    extends SCKeyMapping {
        private static final int MAX_COOLDOWN = 30;
        private int cooldown = 30;
        private Consumer<SecurityCamera> action;

        public TickingKeyMapping(String name, int defaultKey, Consumer<SecurityCamera> action) {
            super(name, defaultKey);
            this.action = action;
        }

        public void tick(SecurityCamera t) {
            --this.cooldown;
            if (this.consumeClick() && this.cooldown <= 0) {
                this.action.accept(t);
                this.cooldown = 30;
            }
        }
    }
}

