/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.components.SavedBlockState;
import net.geforcemods.securitycraft.inventory.ModuleItemContainer;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class DisguiseModuleMenu
extends StateSelectorAccessMenu {
    private ModuleItemContainer inventory;

    public DisguiseModuleMenu(int windowId, Inventory playerInventory, ModuleItemContainer moduleInventory) {
        super((MenuType)SCContent.DISGUISE_MODULE_MENU.get(), windowId);
        int i;
        this.inventory = moduleInventory;
        moduleInventory.setMenu(this);
        this.addSlot(new AddonSlot(this.inventory, 0, 80, 20));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            int size = this.inventory.getContainerSize();
            slotStackCopy = slotStack.copy();
            if (index < size) {
                if (!this.moveItemStackTo(slotStack, size, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, slotStackCopy);
            } else if (!this.moveItemStackTo(slotStack, 0, size, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
            this.broadcastChanges();
        }
        return slotStackCopy;
    }

    public void clicked(int slot, int dragType, ClickType clickType, Player player) {
        if (slot < 0 || this.getSlot(slot) == null || this.getSlot(slot).getItem().getItem() != SCContent.DISGUISE_MODULE.get()) {
            super.clicked(slot, dragType, clickType, player);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public ItemStack getStateStack() {
        return ((Slot)this.slots.get(0)).getItem();
    }

    @Override
    public BlockState getSavedState() {
        return ((SavedBlockState)this.inventory.getModule().getOrDefault(SCContent.SAVED_BLOCK_STATE, (Object)SavedBlockState.EMPTY)).state();
    }

    @Override
    public StandingOrWallType getStandingOrWallType() {
        return ((SavedBlockState)this.inventory.getModule().getOrDefault(SCContent.SAVED_BLOCK_STATE, (Object)SavedBlockState.EMPTY)).standingOrWallType();
    }

    public ModuleItemContainer getInventory() {
        return this.inventory;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen((ContainerUser)player);
    }

    public static class AddonSlot
    extends Slot {
        public AddonSlot(ModuleItemContainer inventory, int index, int xPos, int yPos) {
            super((Container)inventory, index, xPos, yPos);
        }

        public boolean mayPlace(ItemStack itemStack) {
            return itemStack.getItem() instanceof BlockItem;
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

