/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.blockentities.KeyPanelBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractPanelBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KeyPanelBlock
extends AbstractPanelBlock {
    public static final VoxelShape FLOOR_NS = Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)15.0);
    public static final VoxelShape FLOOR_EW = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)14.0);
    public static final VoxelShape CEILING_NS = Block.box((double)2.0, (double)15.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    public static final VoxelShape CEILING_EW = Block.box((double)1.0, (double)15.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0);
    public static final VoxelShape WALL_N = Block.box((double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0, (double)16.0);
    public static final VoxelShape WALL_E = Block.box((double)0.0, (double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0);
    public static final VoxelShape WALL_S = Block.box((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0);
    public static final VoxelShape WALL_W = Block.box((double)15.0, (double)1.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0);

    public KeyPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        KeyPanelBlockEntity be = (KeyPanelBlockEntity)level.getBlockEntity(pos);
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && be.getSignalLength() > 0) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide()) {
            if (be.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(state, level, pos, be.getSignalLength());
                } else {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.getValue((Property)FACE)) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield FLOOR_NS;
                    }
                    case EAST: 
                    case WEST: {
                        yield FLOOR_EW;
                    }
                }
                yield Shapes.empty();
            }
            case AttachFace.CEILING -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield CEILING_NS;
                    }
                    case EAST: 
                    case WEST: {
                        yield CEILING_EW;
                    }
                }
                yield Shapes.empty();
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield WALL_N;
                    }
                    case EAST: {
                        yield WALL_E;
                    }
                    case SOUTH: {
                        yield WALL_S;
                    }
                    case WEST: {
                        yield WALL_W;
                    }
                }
                yield Shapes.empty();
            }
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.empty();
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KeyPanelBlockEntity(pos, state);
    }
}

