/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.entity.sentry.Bullet;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.inventory.InsertOnlyResourceHandler;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.TrophySystemMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.arrow.ThrownTrident;
import net.minecraft.world.entity.projectile.throwableitemprojectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownExperienceBottle;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;

public class TrophySystemBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
ILockable,
IToggleableEntries<EntityType<?>>,
MenuProvider,
ContainerListener {
    public static final int RANGE = 10;
    private final Map<EntityType<?>, Boolean> projectileFilter = new LinkedHashMap();
    private Projectile entityBeingTargeted = null;
    private int cooldown = this.getCooldownTime();
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private LensContainer lens = new LensContainer(1);

    public TrophySystemBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get(), pos, state);
        this.lens.addListener(this);
        this.projectileFilter.put((EntityType)SCContent.BULLET_ENTITY.get(), true);
        this.projectileFilter.put(EntityType.SPECTRAL_ARROW, true);
        this.projectileFilter.put(EntityType.ARROW, true);
        this.projectileFilter.put(EntityType.SMALL_FIREBALL, true);
        this.projectileFilter.put((EntityType)SCContent.IMS_BOMB_ENTITY.get(), true);
        this.projectileFilter.put(EntityType.FIREBALL, true);
        this.projectileFilter.put(EntityType.DRAGON_FIREBALL, true);
        this.projectileFilter.put(EntityType.WITHER_SKULL, true);
        this.projectileFilter.put(EntityType.SHULKER_BULLET, true);
        this.projectileFilter.put(EntityType.LLAMA_SPIT, true);
        this.projectileFilter.put(EntityType.EGG, true);
        this.projectileFilter.put(EntityType.ENDER_PEARL, true);
        this.projectileFilter.put(EntityType.SNOWBALL, true);
        this.projectileFilter.put(EntityType.FIREWORK_ROCKET, true);
        this.projectileFilter.put(EntityType.PIG, false);
        this.projectileFilter.put(EntityType.BREEZE_WIND_CHARGE, true);
        this.projectileFilter.put(EntityType.WIND_CHARGE, true);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        Projectile target;
        if (this.isDisabled()) {
            return;
        }
        if (!level.isClientSide() && this.getTarget() == null && (target = this.getPotentialTarget(level, pos)) != null) {
            Entity shooter = target.getOwner();
            boolean shouldTarget = true;
            if (shooter != null) {
                if (shooter.getUUID() != null && shooter.getUUID().toString().equals(this.getOwner().getUUID())) {
                    shouldTarget = !this.ignoresOwner();
                } else if (this.isAllowed(shooter.getName().toString()) || TeamUtils.areOnSameTeam(new Owner(shooter), this.getOwner())) {
                    shouldTarget = false;
                }
            }
            if (shouldTarget) {
                this.setTarget(target);
            }
        }
        if (this.getTarget() == null) {
            return;
        }
        if (!this.getTarget().isAlive()) {
            this.resetTarget();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.destroyTarget();
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        ValueOutput projectilesNBT = tag.child("projectiles");
        int i = 0;
        for (boolean b : this.projectileFilter.values()) {
            projectilesNBT.putBoolean("projectile" + i, b);
            ++i;
        }
        this.lens.storeAsItemList(tag.list("lens", ItemStack.CODEC));
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        ValueInput projectilesNBT = tag.childOrEmpty("projectiles");
        int i = 0;
        for (EntityType<?> projectileType : this.projectileFilter.keySet()) {
            this.projectileFilter.put(projectileType, projectilesNBT.getBooleanOr("projectile" + i, this.projectileFilter.get(projectileType).booleanValue()));
            ++i;
        }
        this.lens.fromItemList(tag.listOrEmpty("lens", ItemStack.CODEC));
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue()) {
                this.dropAllModules();
            }
            Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.getLensContainer());
        }
        super.preRemoveSideEffects(pos, state);
    }

    public static ResourceHandler<ItemResource> getCapability(TrophySystemBlockEntity be, Direction side) {
        ResourceHandler resourceHandler = VanillaContainerWrapper.of((Container)be.lens);
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? resourceHandler : new InsertOnlyResourceHandler(resourceHandler);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    public SimpleContainer getLensContainer() {
        return this.lens;
    }

    public void containerChanged(Container container) {
        if (this.level == null) {
            return;
        }
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new TrophySystemMenu(id, this.level, this.worldPosition, inventory);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    public void setTarget(Projectile target) {
        this.entityBeingTargeted = target;
        this.setChanged();
        if (!this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new SetTrophySystemTarget(this.worldPosition, target.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void destroyTarget() {
        this.getTarget().remove(Entity.RemovalReason.KILLED);
        if (!this.level.isClientSide()) {
            this.level.explode(null, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 0.1f, Level.ExplosionInteraction.NONE);
        }
        this.resetTarget();
    }

    private void resetTarget() {
        this.cooldown = this.getCooldownTime();
        this.entityBeingTargeted = null;
        this.setChanged();
    }

    private Projectile getPotentialTarget(Level level, BlockPos pos) {
        List<Object> potentialTargets = new ArrayList();
        AABB area = new AABB(pos).inflate(10.0);
        potentialTargets.addAll(level.getEntitiesOfClass(Projectile.class, area, this::isAllowedToTarget));
        potentialTargets = potentialTargets.stream().filter(this::filterSCProjectiles).collect(Collectors.toList());
        if (potentialTargets.isEmpty()) {
            return null;
        }
        int target = SecurityCraft.RANDOM.nextInt(potentialTargets.size());
        return (Projectile)potentialTargets.get(target);
    }

    private boolean isAllowedToTarget(Projectile target) {
        if (target instanceof ThrownTrident || target instanceof FishingHook || target instanceof AbstractThrownPotion || target instanceof ThrownExperienceBottle) {
            return false;
        }
        return this.projectileFilter.getOrDefault(target.getType(), this.projectileFilter.get(EntityType.PIG));
    }

    private boolean filterSCProjectiles(Projectile projectile) {
        Projectile projectile2 = projectile;
        Objects.requireNonNull(projectile2);
        Projectile projectile3 = projectile2;
        int n = 0;
        Owner owner = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Bullet.class, IMSBomb.class}, (Object)projectile3, n)) {
            case 0 -> {
                Bullet bullet = (Bullet)projectile3;
                yield bullet.getSCOwner();
            }
            case 1 -> {
                IMSBomb imsBomb = (IMSBomb)projectile3;
                yield imsBomb.getSCOwner();
            }
            default -> {
                Entity var8_6 = projectile.getOwner();
                if (var8_6 instanceof Sentry) {
                    Sentry sentry = (Sentry)var8_6;
                    yield sentry.getOwner();
                }
                yield null;
            }
        };
        return owner == null || !owner.owns(this) && !this.isAllowed(owner.getName());
    }

    @Override
    public void setFilter(EntityType<?> projectileType, boolean allowed) {
        if (this.projectileFilter.containsKey(projectileType)) {
            this.projectileFilter.put(projectileType, allowed);
            this.setChanged();
            if (this.level.isClientSide()) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncTrophySystem(this.worldPosition, Utils.getRegistryName(projectileType), allowed), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public boolean getFilter(EntityType<?> projectileType) {
        return this.projectileFilter.get(projectileType);
    }

    @Override
    public Map<EntityType<?>, Boolean> getFilters() {
        return this.projectileFilter;
    }

    @Override
    public EntityType<?> getDefaultType() {
        return EntityType.PIG;
    }

    @Override
    public String getDefaultTypeName() {
        return "gui.securitycraft:trophy_system.moddedProjectiles";
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.SMART) {
            for (EntityType<?> projectileType : this.projectileFilter.keySet()) {
                this.projectileFilter.put(projectileType, projectileType != EntityType.PIG);
            }
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.SMART, ModuleType.SPEED, ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner};
    }

    public int getCooldownTime() {
        return this.isModuleEnabled(ModuleType.SPEED) ? 4 : 8;
    }

    public Projectile getTarget() {
        return this.entityBeingTargeted;
    }
}

