/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadBarrelBlock;
import net.geforcemods.securitycraft.entity.sentry.ISentryBulletContainer;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.inventory.InsertOnlyResourceHandler;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;

public class KeypadBarrelBlockEntity
extends RandomizableContainerBlockEntity
implements IPasscodeProtected,
IOwnable,
IModuleInventory,
ICustomizable,
ILockable,
ISentryBulletContainer {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            KeypadBarrelBlockEntity.this.playSound(state, (Boolean)state.getValue((Property)KeypadBarrelBlock.FROG) != false ? SoundEvents.FROG_AMBIENT : SoundEvents.BARREL_OPEN);
            KeypadBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            KeypadBarrelBlockEntity.this.playSound(state, (Boolean)state.getValue((Property)KeypadBarrelBlock.FROG) != false ? SoundEvents.FROG_DEATH : SoundEvents.BARREL_CLOSE);
            KeypadBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int count, int openCount) {
        }

        public boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ChestMenu) {
                ChestMenu menu = (ChestMenu)abstractContainerMenu;
                return menu.getContainer() == KeypadBarrelBlockEntity.this;
            }
            return false;
        }
    };
    private byte[] passcode;
    private UUID saltKey;
    private boolean saveSalt = false;
    private Owner owner = new Owner();
    private NonNullList<ItemStack> modules = NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY);
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);
    private Identifier previousBarrel;

    public KeypadBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_BARREL_BLOCK_ENTITY.get(), pos, state);
    }

    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((ValueOutput)tag, this.items);
        }
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        tag.putLong("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        this.savePasscodeAndSalt(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        if (this.previousBarrel != null) {
            tag.putString("previous_barrel", this.previousBarrel.toString());
        }
    }

    public void loadAdditional(ValueInput tag) {
        Identifier parsedPreviousBarrel;
        super.loadAdditional(tag);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((ValueInput)tag, this.items);
        }
        this.readModuleInventory(this.modules, tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.getLongOr("cooldownLeft", 0L);
        this.loadPasscodeAndSaltKey(tag);
        this.owner.load(tag);
        String savedPreviousBarrel = tag.getStringOr("previous_barrel", "");
        if (!savedPreviousBarrel.isBlank() && (parsedPreviousBarrel = Identifier.parse((String)savedPreviousBarrel)).getPath() != null && !parsedPreviousBarrel.getPath().isBlank()) {
            this.previousBarrel = parsedPreviousBarrel;
        }
        if (!tag.getBooleanOr("sendMessage", true)) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        SaltData.removeSalt(this.saltKey);
        super.preRemoveSideEffects(pos, state);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted((BlockEntity)this, stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved((BlockEntity)this, stack, toggled);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return PasscodeUtils.filterPasscodeAndSaltFromTag(this.saveCustomOnly(lookupProvider));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ValueInput tag) {
        super.onDataPacket(net, tag);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public Component getDefaultName() {
        return Utils.localize(((KeypadBarrelBlock)SCContent.KEYPAD_BARREL.get()).getDescriptionId(), new Object[0]);
    }

    public static ResourceHandler<ItemResource> getCapability(KeypadBarrelBlockEntity be, Direction side) {
        ResourceHandler resourceHandler = VanillaContainerWrapper.of((Container)be);
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? resourceHandler : new InsertOnlyResourceHandler(resourceHandler);
    }

    @Override
    public ResourceHandler<ItemResource> getHandlerForSentry(Sentry entity) {
        if (entity.getOwner().owns(this)) {
            return VanillaContainerWrapper.of((Container)this);
        }
        return null;
    }

    public int getContainerSize() {
        return 27;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.level.isClientSide() && (block = this.getBlockState().getBlock()) instanceof KeypadBarrelBlock) {
            KeypadBarrelBlock block2 = (KeypadBarrelBlock)block;
            block2.activate(this.getBlockState(), this.level, this.worldPosition, player);
        }
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return ChestMenu.threeRows((int)id, (Inventory)playerInventory, (Container)this);
    }

    @Override
    public void dropAllModules() {
        for (ItemStack module : this.getInventory()) {
            if (!(module.getItem() instanceof ModuleItem)) continue;
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)module);
        }
        this.getInventory().clear();
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.setChanged();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void setSaveSalt(boolean saveSalt) {
        this.saveSalt = saveSalt;
    }

    @Override
    public boolean shouldSaveSalt() {
        return this.saveSalt;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.setChanged();
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public void startCooldown() {
        this.startCooldown(System.currentTimeMillis());
    }

    public void startCooldown(long start) {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = start + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            this.setChanged();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.smartModuleCooldown};
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    public void setRemoved() {
        super.setRemoved();
        DisguisableBlockEntity.onSetRemoved((BlockEntity)this);
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData((BlockEntity)this);
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public void startOpen(ContainerUser player) {
        if (!this.remove && !player.getLivingEntity().isSpectator()) {
            this.openersCounter.incrementOpeners(player.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState(), player.getContainerInteractionRange());
        }
    }

    public void stopOpen(ContainerUser player) {
        if (!this.remove && !player.getLivingEntity().isSpectator()) {
            this.openersCounter.decrementOpeners(player.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void updateBlockState(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)KeypadBarrelBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void playSound(BlockState state, SoundEvent sound) {
        Direction normalFacing = switch ((KeypadBarrelBlock.LidFacing)((Object)state.getValue(KeypadBarrelBlock.LID_FACING))) {
            default -> throw new MatchException(null, null);
            case KeypadBarrelBlock.LidFacing.UP -> Direction.UP;
            case KeypadBarrelBlock.LidFacing.SIDEWAYS -> (Direction)state.getValue(KeypadBarrelBlock.HORIZONTAL_FACING);
            case KeypadBarrelBlock.LidFacing.DOWN -> Direction.DOWN;
        };
        Vec3i facingNormal = normalFacing.getUnitVec3i();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)facingNormal.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)facingNormal.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)facingNormal.getZ() / 2.0;
        this.level.playSound(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void setPreviousBarrel(Block previousBarrel) {
        this.previousBarrel = Utils.getRegistryName(previousBarrel);
    }

    public Identifier getPreviousBarrel() {
        return this.previousBarrel;
    }

    @Override
    public Level myLevel() {
        return this.level;
    }

    @Override
    public BlockPos myPos() {
        return this.worldPosition;
    }
}

