/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.components.CodebreakerData;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface ICodebreakable {
    public boolean shouldAttemptCodebreak(Player var1);

    public void useCodebreaker(Player var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean handleCodebreaking(Player player, InteractionHand hand) {
        ItemStack codebreaker = player.getItemInHand(hand);
        double chance = CodebreakerItem.getSuccessChance(codebreaker);
        if (chance < 0.0) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
            return true;
        } else {
            boolean isSuccessful;
            IOwnable ownable;
            if (!this.shouldAttemptCodebreak(player)) {
                return false;
            }
            if (!codebreaker.is((Item)SCContent.CODEBREAKER.get())) return false;
            boolean canBypass = player.isCreative() || player.isSpectator();
            ICodebreakable iCodebreakable = this;
            if (iCodebreakable instanceof IOwnable && (ownable = (IOwnable)((Object)iCodebreakable)).isOwnedBy((Entity)player) && !canBypass) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.owned", new Object[0]), ChatFormatting.RED);
                return false;
            }
            if (!canBypass && ((CodebreakerData)codebreaker.getOrDefault(SCContent.CODEBREAKER_DATA, (Object)CodebreakerData.DEFAULT)).wasRecentlyUsed()) {
                return false;
            }
            boolean bl = isSuccessful = canBypass || SecurityCraft.RANDOM.nextDouble() < chance;
            if (!canBypass) {
                codebreaker.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
            }
            codebreaker.set(SCContent.CODEBREAKER_DATA, (Object)new CodebreakerData(System.currentTimeMillis(), isSuccessful));
            if (isSuccessful) {
                this.useCodebreaker(player);
                return true;
            } else {
                PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId()), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                return false;
            }
        }
    }
}

