/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCCreativeModeTabs;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AbstractKeypadFurnaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadBarrelBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedChiseledBookshelfBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedDispenserBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedHopperBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedShelfBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.entity.AbstractSecuritySeaBoat;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.BlockPocketManagerFailedActivation;
import net.geforcemods.securitycraft.network.client.InteractWithFrame;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.network.client.PlayAlarmSound;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.geforcemods.securitycraft.network.client.SendManualPages;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.client.UpdateLaserColors;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.CheckBriefcasePasscode;
import net.geforcemods.securitycraft.network.server.CheckPasscode;
import net.geforcemods.securitycraft.network.server.ClearChangeDetectorServer;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.network.server.RemoveMineFromMRAT;
import net.geforcemods.securitycraft.network.server.RemovePositionFromSSS;
import net.geforcemods.securitycraft.network.server.RemoveSentryFromSRAT;
import net.geforcemods.securitycraft.network.server.SetBriefcasePasscodeAndOwner;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetDefaultCameraViewingDirection;
import net.geforcemods.securitycraft.network.server.SetGhostSlot;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.network.server.SetPasscode;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.network.server.SetStateOnDisguiseModule;
import net.geforcemods.securitycraft.network.server.SyncAlarmSettings;
import net.geforcemods.securitycraft.network.server.SyncBlockChangeDetector;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.network.server.SyncBlockReinforcer;
import net.geforcemods.securitycraft.network.server.SyncFrame;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.network.server.SyncLaserSideConfig;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.network.server.SyncSecureRedstoneInterface;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleNightVision;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.util.RegisterItemBlock;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.SCItemGroup;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.world.poi.ExtendPoiTypesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.transfer.fluid.BucketResourceHandler;

@EventBusSubscriber(modid="securitycraft")
public class RegistrationHandler {
    private RegistrationHandler() {
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        event.register(Registries.ITEM, helper -> {
            for (Field field : SCContent.class.getFields()) {
                try {
                    BlockItem blockItem;
                    Block block;
                    DeferredBlock deferredBlock;
                    SCItemGroup group;
                    if (field.isAnnotationPresent(Reinforced.class) && field.getAnnotation(Reinforced.class).registerBlockItem()) {
                        group = field.getAnnotation(Reinforced.class).itemGroup();
                        deferredBlock = (DeferredBlock)field.get(null);
                        block = (Block)deferredBlock.get();
                        blockItem = new BlockItem(block, SCContent.setId(deferredBlock.getKey().identifier().getPath(), new Item.Properties().fireResistant(), true));
                        helper.register(Utils.getRegistryName(block), (Object)blockItem);
                        if (group == SCItemGroup.MANUAL) continue;
                        SCCreativeModeTabs.STACKS_FOR_ITEM_GROUPS.get((Object)group).add(new ItemStack((ItemLike)blockItem));
                        continue;
                    }
                    if (!field.isAnnotationPresent(RegisterItemBlock.class)) continue;
                    group = field.getAnnotation(RegisterItemBlock.class).value();
                    deferredBlock = (DeferredBlock)field.get(null);
                    block = (Block)deferredBlock.get();
                    blockItem = new BlockItem(block, SCContent.setId(deferredBlock.getKey().identifier().getPath(), new Item.Properties(), true));
                    helper.register(Utils.getRegistryName(block), (Object)blockItem);
                    if (group == SCItemGroup.MANUAL) continue;
                    SCCreativeModeTabs.STACKS_FOR_ITEM_GROUPS.get((Object)group).add(new ItemStack((ItemLike)blockItem));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
        event.register(Registries.SOUND_EVENT, helper -> {
            for (int i = 0; i < SCSounds.values().length; ++i) {
                SCSounds sound = SCSounds.values()[i];
                helper.register(sound.location, (Object)sound.event);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCContent.SENTRY_ENTITY.get(), Mob.createMobAttributes().build());
    }

    @SubscribeEvent
    public static void onExtendPoiTypes(ExtendPoiTypesEvent event) {
        event.addBlockToPoi(PoiTypes.LIGHTNING_ROD, (Block)SCContent.REINFORCED_LIGHTNING_ROD.get());
        event.addBlockToPoi(PoiTypes.LIGHTNING_ROD, (Block)SCContent.REINFORCED_EXPOSED_LIGHTNING_ROD.get());
        event.addBlockToPoi(PoiTypes.LIGHTNING_ROD, (Block)SCContent.REINFORCED_WEATHERED_LIGHTNING_ROD.get());
        event.addBlockToPoi(PoiTypes.LIGHTNING_ROD, (Block)SCContent.REINFORCED_OXIDIZED_LIGHTNING_ROD.get());
    }

    @SubscribeEvent
    public static void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("securitycraft").versioned(SecurityCraft.getVersion());
        registrar.playToClient(BlockPocketManagerFailedActivation.TYPE, BlockPocketManagerFailedActivation.STREAM_CODEC);
        registrar.playToClient(InteractWithFrame.TYPE, InteractWithFrame.STREAM_CODEC);
        registrar.playToClient(OpenScreen.TYPE, OpenScreen.STREAM_CODEC);
        registrar.playToClient(PlayAlarmSound.TYPE, PlayAlarmSound.STREAM_CODEC);
        registrar.playToClient(RefreshDisguisableModel.TYPE, RefreshDisguisableModel.STREAM_CODEC);
        registrar.playToClient(SendManualPages.TYPE, SendManualPages.STREAM_CODEC);
        registrar.playToClient(SetCameraView.TYPE, SetCameraView.STREAM_CODEC);
        registrar.playToClient(SetTrophySystemTarget.TYPE, SetTrophySystemTarget.STREAM_CODEC);
        registrar.playToClient(UpdateLaserColors.TYPE, UpdateLaserColors.STREAM_CODEC);
        registrar.playToClient(UpdateLogger.TYPE, UpdateLogger.STREAM_CODEC);
        registrar.playToServer(AssembleBlockPocket.TYPE, AssembleBlockPocket.STREAM_CODEC, AssembleBlockPocket::handle);
        registrar.playToServer(CheckBriefcasePasscode.TYPE, CheckBriefcasePasscode.STREAM_CODEC, CheckBriefcasePasscode::handle);
        registrar.playToServer(CheckPasscode.TYPE, CheckPasscode.STREAM_CODEC, CheckPasscode::handle);
        registrar.playToServer(ClearChangeDetectorServer.TYPE, ClearChangeDetectorServer.STREAM_CODEC, ClearChangeDetectorServer::handle);
        registrar.playToServer(ClearLoggerServer.TYPE, ClearLoggerServer.STREAM_CODEC, ClearLoggerServer::handle);
        registrar.playToServer(DismountCamera.TYPE, DismountCamera.STREAM_CODEC, DismountCamera::handle);
        registrar.playToServer(MountCamera.TYPE, MountCamera.STREAM_CODEC, MountCamera::handle);
        registrar.playToServer(RemoteControlMine.TYPE, RemoteControlMine.STREAM_CODEC, RemoteControlMine::handle);
        registrar.playToServer(RemoveCameraTag.TYPE, RemoveCameraTag.STREAM_CODEC, RemoveCameraTag::handle);
        registrar.playToServer(RemoveMineFromMRAT.TYPE, RemoveMineFromMRAT.STREAM_CODEC, RemoveMineFromMRAT::handle);
        registrar.playToServer(RemovePositionFromSSS.TYPE, RemovePositionFromSSS.STREAM_CODEC, RemovePositionFromSSS::handle);
        registrar.playToServer(RemoveSentryFromSRAT.TYPE, RemoveSentryFromSRAT.STREAM_CODEC, RemoveSentryFromSRAT::handle);
        registrar.playToServer(SetBriefcasePasscodeAndOwner.TYPE, SetBriefcasePasscodeAndOwner.STREAM_CODEC, SetBriefcasePasscodeAndOwner::handle);
        registrar.playToServer(SetCameraPowered.TYPE, SetCameraPowered.STREAM_CODEC, SetCameraPowered::handle);
        registrar.playToServer(SetDefaultCameraViewingDirection.TYPE, SetDefaultCameraViewingDirection.STREAM_CODEC, SetDefaultCameraViewingDirection::handle);
        registrar.playToServer(SetGhostSlot.TYPE, SetGhostSlot.STREAM_CODEC, SetGhostSlot::handle);
        registrar.playToServer(SetKeycardUses.TYPE, SetKeycardUses.STREAM_CODEC, SetKeycardUses::handle);
        registrar.playToServer(SetListModuleData.TYPE, SetListModuleData.STREAM_CODEC, SetListModuleData::handle);
        registrar.playToServer(SetPasscode.TYPE, SetPasscode.STREAM_CODEC, SetPasscode::handle);
        registrar.playToServer(SetSentryMode.TYPE, SetSentryMode.STREAM_CODEC, SetSentryMode::handle);
        registrar.playToServer(SetStateOnDisguiseModule.TYPE, SetStateOnDisguiseModule.STREAM_CODEC, SetStateOnDisguiseModule::handle);
        registrar.playToServer(SyncAlarmSettings.TYPE, SyncAlarmSettings.STREAM_CODEC, SyncAlarmSettings::handle);
        registrar.playToServer(SyncBlockChangeDetector.TYPE, SyncBlockChangeDetector.STREAM_CODEC, SyncBlockChangeDetector::handle);
        registrar.playToServer(SyncBlockPocketManager.TYPE, SyncBlockPocketManager.STREAM_CODEC, SyncBlockPocketManager::handle);
        registrar.playToServer(SyncBlockReinforcer.TYPE, SyncBlockReinforcer.STREAM_CODEC, SyncBlockReinforcer::handle);
        registrar.playToServer(SyncFrame.TYPE, SyncFrame.STREAM_CODEC, SyncFrame::handle);
        registrar.playToServer(SyncKeycardSettings.TYPE, SyncKeycardSettings.STREAM_CODEC, SyncKeycardSettings::handle);
        registrar.playToServer(SyncLaserSideConfig.TYPE, SyncLaserSideConfig.STREAM_CODEC, SyncLaserSideConfig::handle);
        registrar.playToServer(SyncProjector.TYPE, SyncProjector.STREAM_CODEC, SyncProjector::handle);
        registrar.playToServer(SyncRiftStabilizer.TYPE, SyncRiftStabilizer.STREAM_CODEC, SyncRiftStabilizer::handle);
        registrar.playToServer(SyncSSSSettingsOnServer.TYPE, SyncSSSSettingsOnServer.STREAM_CODEC, SyncSSSSettingsOnServer::handle);
        registrar.playToServer(SyncSecureRedstoneInterface.TYPE, SyncSecureRedstoneInterface.STREAM_CODEC, SyncSecureRedstoneInterface::handle);
        registrar.playToServer(SyncTrophySystem.TYPE, SyncTrophySystem.STREAM_CODEC, SyncTrophySystem::handle);
        registrar.playToServer(ToggleBlockPocketManager.TYPE, ToggleBlockPocketManager.STREAM_CODEC, ToggleBlockPocketManager::handle);
        registrar.playToServer(ToggleModule.TYPE, ToggleModule.STREAM_CODEC, ToggleModule::handle);
        registrar.playToServer(ToggleNightVision.TYPE, ToggleNightVision.STREAM_CODEC, ToggleNightVision::handle);
        registrar.playToServer(ToggleOption.TYPE, ToggleOption.STREAM_CODEC, ToggleOption::handle);
        registrar.playToServer(UpdateSliderValue.TYPE, UpdateSliderValue.STREAM_CODEC, UpdateSliderValue::handle);
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.KEYPAD_BLAST_FURNACE_BLOCK_ENTITY.get(), AbstractKeypadFurnaceBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.KEYPAD_FURNACE_BLOCK_ENTITY.get(), AbstractKeypadFurnaceBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.KEYPAD_SMOKER_BLOCK_ENTITY.get(), AbstractKeypadFurnaceBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.BLOCK_POCKET_MANAGER_BLOCK_ENTITY.get(), BlockPocketManagerBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), ClaymoreBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), InventoryScannerBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.KEYPAD_BARREL_BLOCK_ENTITY.get(), KeypadBarrelBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), (chest, dir) -> KeypadChestBlockEntity.getCapability((KeypadChestBlockEntity)chest, dir));
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), LaserBlockBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get(), ReinforcedHopperBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get(), TrophySystemBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.REINFORCED_CHISELED_BOOKSHELF_BLOCK_ENTITY.get(), ReinforcedChiseledBookshelfBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.REINFORCED_DISPENSER_BLOCK_ENTITY.get(), ReinforcedDispenserBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.REINFORCED_SHELF_BLOCK_ENTITY.get(), ReinforcedShelfBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.REINFORCED_DROPPER_BLOCK_ENTITY.get(), ReinforcedDispenserBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), SecurityCameraBlockEntity::getCapability);
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.OAK_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.SPRUCE_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.BIRCH_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.JUNGLE_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.ACACIA_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.DARK_OAK_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.MANGROVE_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.CHERRY_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.PALE_OAK_SECURITY_SEA_BOAT_ENTITY.get()));
        RegistrationHandler.registerSecuritySeaBoatCapabilities(event, (EntityType<? extends AbstractSecuritySeaBoat>)((EntityType)SCContent.BAMBOO_SECURITY_SEA_RAFT_ENTITY.get()));
        event.registerItem(Capabilities.Fluid.ITEM, (stack, access) -> new BucketResourceHandler(access), new ItemLike[]{SCContent.FAKE_WATER_BUCKET});
        event.registerItem(Capabilities.Fluid.ITEM, (stack, access) -> new BucketResourceHandler(access), new ItemLike[]{SCContent.FAKE_LAVA_BUCKET});
    }

    private static void registerSecuritySeaBoatCapabilities(RegisterCapabilitiesEvent event, EntityType<? extends AbstractSecuritySeaBoat> boatType) {
        event.registerEntity(Capabilities.Item.ENTITY, boatType, (boat, ctx) -> AbstractSecuritySeaBoat.getCapability(boat, null));
        event.registerEntity(Capabilities.Item.ENTITY_AUTOMATION, boatType, AbstractSecuritySeaBoat::getCapability);
    }

    @SubscribeEvent
    public static void onCreativeModeTabRegister(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        if (tabKey.equals(CreativeModeTabs.REDSTONE_BLOCKS)) {
            event.insertAfter(new ItemStack((ItemLike)Items.LEVER), new ItemStack((ItemLike)SCContent.REINFORCED_LEVER.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.STONE_BUTTON), new ItemStack((ItemLike)SCContent.REINFORCED_OAK_BUTTON.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.REINFORCED_OAK_BUTTON.get()), new ItemStack((ItemLike)SCContent.REINFORCED_STONE_BUTTON.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.REINFORCED_STONE_BUTTON.get()), new ItemStack((ItemLike)SCContent.PANIC_BUTTON.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.STONE_PRESSURE_PLATE), new ItemStack((ItemLike)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_STONE_PRESSURE_PLATE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.STICKY_PISTON), new ItemStack((ItemLike)SCContent.REINFORCED_PISTON.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.REINFORCED_PISTON.get()), new ItemStack((ItemLike)SCContent.REINFORCED_STICKY_PISTON.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.DROPPER), new ItemStack((ItemLike)SCContent.REINFORCED_DISPENSER.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.REINFORCED_DISPENSER.get()), new ItemStack((ItemLike)SCContent.REINFORCED_DROPPER.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.HOPPER), new ItemStack((ItemLike)SCContent.REINFORCED_HOPPER.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.LECTERN), new ItemStack((ItemLike)SCContent.REINFORCED_LECTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (tabKey.equals(CreativeModeTabs.COLORED_BLOCKS)) {
            event.acceptAll(List.of(new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_TINTED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_STAINED_GLASS_PANE.get())));
        } else if (tabKey.equals(SCCreativeModeTabs.DECORATION_TAB.getKey())) {
            try {
                event.insertAfter(new ItemStack((ItemLike)SCContent.REINFORCED_LADDER.get()), new ItemStack((ItemLike)SCContent.REINFORCED_SCAFFOLDING_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.insertAfter(new ItemStack((ItemLike)SCContent.REINFORCED_LECTERN.get()), new ItemStack((ItemLike)SCContent.SECRET_OAK_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
            catch (IllegalArgumentException e) {
                event.accept(new ItemStack((ItemLike)SCContent.REINFORCED_SCAFFOLDING_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(new ItemStack((ItemLike)SCContent.SECRET_OAK_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_OAK_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_OAK_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_OAK_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_BIRCH_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_BIRCH_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_BIRCH_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_BIRCH_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_ACACIA_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_ACACIA_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_ACACIA_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_ACACIA_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_CHERRY_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_CHERRY_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_CHERRY_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_CHERRY_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_PALE_OAK_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_PALE_OAK_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_PALE_OAK_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_PALE_OAK_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_BAMBOO_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_BAMBOO_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_BAMBOO_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_BAMBOO_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_HANGING_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_WARPED_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)SCContent.SECRET_WARPED_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_WARPED_HANGING_SIGN_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (tabKey.equals(CreativeModeTabs.OP_BLOCKS)) {
            if (event.getParameters().hasPermissions()) {
                event.accept(new ItemStack((ItemLike)SCContent.ADMIN_TOOL.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(new ItemStack((ItemLike)SCContent.CODEBREAKER.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        } else if (tabKey.equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
            event.insertAfter(new ItemStack((ItemLike)Items.OAK_CHEST_BOAT), new ItemStack((ItemLike)SCContent.OAK_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.SPRUCE_CHEST_BOAT), new ItemStack((ItemLike)SCContent.SPRUCE_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.BIRCH_CHEST_BOAT), new ItemStack((ItemLike)SCContent.BIRCH_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.JUNGLE_CHEST_BOAT), new ItemStack((ItemLike)SCContent.JUNGLE_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.ACACIA_CHEST_BOAT), new ItemStack((ItemLike)SCContent.ACACIA_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.DARK_OAK_CHEST_BOAT), new ItemStack((ItemLike)SCContent.DARK_OAK_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.MANGROVE_CHEST_BOAT), new ItemStack((ItemLike)SCContent.MANGROVE_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.CHERRY_CHEST_BOAT), new ItemStack((ItemLike)SCContent.CHERRY_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.PALE_OAK_CHEST_BOAT), new ItemStack((ItemLike)SCContent.PALE_OAK_SECURITY_SEA_BOAT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.BAMBOO_CHEST_RAFT), new ItemStack((ItemLike)SCContent.BAMBOO_SECURITY_SEA_RAFT.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addRecipe(Ingredient.of((ItemLike)Items.WATER_BUCKET), RegistrationHandler.getPotionIngredient((Holder<Potion>)Potions.HARMING, (Holder<Potion>)Potions.STRONG_HARMING), new ItemStack((ItemLike)SCContent.FAKE_WATER_BUCKET.get()));
        builder.addRecipe(Ingredient.of((ItemLike)Items.LAVA_BUCKET), RegistrationHandler.getPotionIngredient((Holder<Potion>)Potions.HEALING, (Holder<Potion>)Potions.STRONG_HEALING), new ItemStack((ItemLike)SCContent.FAKE_LAVA_BUCKET.get()));
    }

    private static Ingredient getPotionIngredient(Holder<Potion> normalPotion, Holder<Potion> strongPotion) {
        Ingredient normalPotions = DataComponentIngredient.of((boolean)false, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(normalPotion), (ItemLike[])new ItemLike[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION});
        Ingredient strongPotions = DataComponentIngredient.of((boolean)false, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(strongPotion), (ItemLike[])new ItemLike[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION});
        return CompoundIngredient.of((Ingredient[])new Ingredient[]{normalPotions, strongPotions});
    }
}

