/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.trait.IAttunementItem;
import net.blay09.mods.waystones.api.trait.IFOVOnUse;
import net.blay09.mods.waystones.api.trait.IResetUseOnDamage;
import net.blay09.mods.waystones.component.BoundScrollComponent;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.ScrollItemBase;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BoundScrollItem
extends ScrollItemBase
implements IResetUseOnDamage,
IFOVOnUse,
IAttunementItem {
    public BoundScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return WaystonesConfig.getActive().general.scrollUseTime;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Optional<Waystone> boundTo = this.getWaystoneAttunedTo(player.level().getServer(), (Player)player, stack);
            boundTo.ifPresent(targetWaystone -> WaystonesAPI.createDefaultTeleportContext((Entity)player, targetWaystone, it -> it.setWarpItem(stack)).mapLeft(WaystonesAPI::tryTeleport).ifLeft(it -> stack.consume(1, (LivingEntity)player)));
        }
        return stack;
    }

    @Override
    public Optional<Waystone> getWaystoneAttunedTo(MinecraftServer server, Player player, ItemStack itemStack) {
        BoundScrollComponent boundScroll = (BoundScrollComponent)itemStack.get((DataComponentType)ModComponents.boundScroll.value());
        if (boundScroll != null) {
            return Optional.of(new WaystoneProxy(server, boundScroll.waystoneId()));
        }
        UUID legacyAttunement = (UUID)itemStack.get((DataComponentType)ModComponents.attunement.value());
        if (legacyAttunement != null) {
            return Optional.of(new WaystoneProxy(server, legacyAttunement));
        }
        return Optional.empty();
    }

    @Override
    public void setWaystoneAttunedTo(ItemStack itemStack, @Nullable Waystone waystone) {
        if (waystone != null) {
            itemStack.set((DataComponentType)ModComponents.boundScroll.value(), (Object)new BoundScrollComponent(waystone.getWaystoneUid(), waystone.getName()));
        } else {
            itemStack.remove((DataComponentType)ModComponents.boundScroll.value());
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        itemStack.addToTooltip((DataComponentType)ModComponents.boundScroll.value(), context, display, list, flag);
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }
}

