/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.blay09.mods.balm.platform.BalmEnvironment;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.event.WaystoneActivatedEvent;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.store.InMemoryWaystonesPlayerStore;
import net.blay09.mods.waystones.store.PersistentWaystonesPlayerStore;
import net.blay09.mods.waystones.store.SavedDataWaystonesStore;
import net.blay09.mods.waystones.store.WaystonesPlayerStore;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGeneratorManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class PlayerWaystoneManager {
    private static final RandomSource random = RandomSource.create();
    private static final WaystonesPlayerStore persistentPlayerWaystoneData = new PersistentWaystonesPlayerStore();
    private static final WaystonesPlayerStore inMemoryPlayerWaystoneData = new InMemoryWaystonesPlayerStore();

    public static boolean isWaystoneActivated(Player player, Waystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(Player player, Waystone waystone) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (waystone instanceof MutableWaystone) {
                MutableWaystone mutableWaystone = (MutableWaystone)((Object)waystone);
                if (!waystone.hasName() && waystone.wasGenerated()) {
                    NameGenerationMode nameGenerationMode = WaystonesConfig.getActive().worldGen.nameGenerationMode;
                    Component name = NameGeneratorManager.get(serverLevel.getServer()).getName((LevelAccessor)player.level(), waystone, random, nameGenerationMode);
                    mutableWaystone.setName(name);
                }
                if (!waystone.hasOwner()) {
                    mutableWaystone.setOwnerUid(player.getUUID());
                    mutableWaystone.setVisibility(WaystonesConfig.getActive().general.defaultVisibility);
                    if (waystone.getVisibility() == WaystoneVisibility.GLOBAL) {
                        PlayerWaystoneManager.activeWaystoneForEveryone(serverLevel.getServer(), waystone);
                    }
                }
            }
            SavedDataWaystonesStore.get(serverLevel.getServer()).setDirty();
        }
        if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone) && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            PlayerWaystoneManager.getPlayerWaystoneData(player.level()).activateWaystone(player, waystone);
            ((Consumer)WaystoneActivatedEvent.EVENT.invoker()).accept(new WaystoneActivatedEvent(player, waystone));
        }
    }

    public static Optional<Waystone> getInventoryButtonTarget(Player player) {
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (inventoryButtonMode.isReturnToNearest()) {
            return PlayerWaystoneManager.getNearestWaystone(player);
        }
        if (inventoryButtonMode.hasNamedTarget()) {
            return Waystones.getWaystoneStore(player).findWaystoneByName(inventoryButtonMode.getNamedTarget());
        }
        return Optional.empty();
    }

    public static void deactivateWaystone(Player player, Waystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).deactivateWaystone(player, waystone);
    }

    public static Map<Identifier, Long> getCooldowns(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getCooldowns(player);
    }

    public static void resetCooldowns(Player player) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).resetCooldowns(player);
    }

    public static long getCooldownUntil(Player player, Identifier key) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getCooldownUntil(player, key);
    }

    public static long getCooldownMillisLeft(Player player, Identifier key) {
        long cooldownUntil = PlayerWaystoneManager.getCooldownUntil(player, key);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setCooldownUntil(Player player, Identifier key, long timestamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).setCooldownUntil(player, key, timestamp);
    }

    public static Optional<Waystone> getNearestWaystone(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getWaystones(player).stream().filter(it -> it.getDimension() == player.level().dimension()).min((first, second) -> {
            double firstDist = first.getPos().distToCenterSqr(player.getX(), player.getY(), player.getZ());
            double secondDist = second.getPos().distToCenterSqr(player.getX(), player.getY(), player.getZ());
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        });
    }

    public static Collection<Waystone> getActivatedWaystones(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getWaystones(player);
    }

    public static WaystonesPlayerStore getPlayerWaystoneData(@Nullable Level world) {
        return world == null || world.isClientSide() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static WaystonesPlayerStore getPlayerWaystoneData(BalmEnvironment side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static List<UUID> getSortingIndex(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).getSortingIndex(player);
    }

    public static List<UUID> ensureSortingIndex(Player player, Collection<Waystone> waystones) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.level()).ensureSortingIndex(player, waystones);
    }

    public static void sortWaystoneAsFirst(Player player, UUID waystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).sortWaystoneAsFirst(player, waystoneUid);
    }

    public static void sortWaystoneAsLast(Player player, UUID waystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).sortWaystoneAsLast(player, waystoneUid);
    }

    public static void sortWaystoneSwap(Player player, UUID waystoneUid, UUID otherWaystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.level()).sortWaystoneSwap(player, waystoneUid, otherWaystoneUid);
    }

    public static void activeWaystoneForEveryone(@Nullable MinecraftServer server, Waystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((Player)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((Player)player, waystone);
        }
    }

    public static void removeKnownWaystone(@Nullable MinecraftServer server, Waystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            PlayerWaystoneManager.deactivateWaystone((Player)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((Player)player);
        }
    }

    public static Collection<Waystone> getTargetsForPlayer(Player player) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    public static Collection<Waystone> getTargetsForItem(Player player, ItemStack itemStack) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    public static Collection<Waystone> getTargetsForWaystone(Player player, Waystone waystone) {
        Collection<Waystone> result = PlayerWaystoneManager.getTargetsForWaystoneType(player, waystone.getWaystoneType());
        BlockEntity blockEntity = player.level().getBlockEntity(waystone.getPos());
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            result.addAll(waystoneBlockEntity.getAuxiliaryTargets());
        }
        return result;
    }

    public static Collection<Waystone> getTargetsForWaystoneType(Player player, Identifier waystoneType) {
        ArrayList<Waystone> result = new ArrayList<Waystone>();
        if (WaystoneTypes.isSharestone(waystoneType)) {
            result.addAll(SavedDataWaystonesStore.get(player.level().getServer()).getWaystonesByType(waystoneType));
        } else {
            result.addAll(PlayerWaystoneManager.getActivatedWaystones(player));
        }
        return result;
    }

    public static Collection<Waystone> getTargetsForInventoryButton(ServerPlayer player) {
        return PlayerWaystoneManager.getActivatedWaystones((Player)player);
    }
}

