/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.requirement;

import net.blay09.mods.waystones.client.requirement.RequirementRenderer;
import net.blay09.mods.waystones.requirement.ExperiencePointsRequirement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;

public class ExperiencePointsRequirementRenderer
implements RequirementRenderer<ExperiencePointsRequirement> {
    private static final Identifier[] ENABLED_LEVEL_SPRITES = new Identifier[]{Identifier.withDefaultNamespace((String)"container/enchanting_table/level_1"), Identifier.withDefaultNamespace((String)"container/enchanting_table/level_2"), Identifier.withDefaultNamespace((String)"container/enchanting_table/level_3")};
    private static final Identifier[] DISABLED_LEVEL_SPRITES = new Identifier[]{Identifier.withDefaultNamespace((String)"container/enchanting_table/level_1_disabled"), Identifier.withDefaultNamespace((String)"container/enchanting_table/level_2_disabled"), Identifier.withDefaultNamespace((String)"container/enchanting_table/level_3_disabled")};

    @Override
    public void renderWidget(Player player, ExperiencePointsRequirement requirement, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, int x, int y) {
        int levels;
        int points = requirement.getPoints();
        int n = levels = points > 0 ? Math.max(1, ExperiencePointsRequirement.calculateLevelCostFromExperiencePoints(player.experienceLevel, points)) : 0;
        if (levels > 0) {
            boolean canAfford = requirement.canAfford(player);
            int spriteIndex = Math.max(0, Math.min(levels, 3) - 1);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, canAfford ? ENABLED_LEVEL_SPRITES[spriteIndex] : DISABLED_LEVEL_SPRITES[spriteIndex], x, y, 16, 16);
            Font font = Minecraft.getInstance().font;
            if (levels > 3) {
                guiGraphics.drawString(font, "+", x + 15, y + 4, -3604593);
            }
        }
    }
}

