/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.scrolling;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.ScrollingTextureData;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.texture.types.base.BaseTextureSprite;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.util.ARGB;

public class ScrollingTextureType
implements TextureType<ScrollingTextureData> {
    @Override
    public ScrollingTextureData deserialize(JsonObject json) throws JsonParseException {
        ScrollingTextureData.Builder builder = ScrollingTextureData.builder();
        if (json.has("from")) {
            ScrollingTextureData.Position from;
            if (!json.get("from").isJsonPrimitive() || !json.getAsJsonPrimitive("from").isString()) {
                throw new JsonParseException("Property 'from' must be a string!");
            }
            String fromString = json.get("from").getAsString();
            try {
                from = ScrollingTextureData.Position.valueOf(fromString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'from' must be one of " + Arrays.toString((Object[])ScrollingTextureData.Position.values()).toLowerCase(Locale.ROOT) + ", not '" + fromString + "'!");
            }
            builder.startPosition(from);
        }
        if (json.has("to")) {
            ScrollingTextureData.Position to;
            if (!json.get("to").isJsonPrimitive() || !json.getAsJsonPrimitive("to").isString()) {
                throw new JsonParseException("Property 'to' must be a string!");
            }
            String toString = json.get("to").getAsString();
            try {
                to = ScrollingTextureData.Position.valueOf(toString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'to' must be one of " + Arrays.toString((Object[])ScrollingTextureData.Position.values()).toLowerCase(Locale.ROOT) + ", not '" + toString + "'!");
            }
            builder.endPosition(to);
        }
        if (json.has("frame_time")) {
            if (!json.get("frame_time").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_time").isNumber()) {
                throw new JsonParseException("Property 'frame_time' must be an integer!");
            }
            int frameTime = json.get("frame_time").getAsNumber().intValue();
            if (frameTime <= 0) {
                throw new JsonParseException("Property 'frame_time' must have a value greater than 0!");
            }
            builder.frameTime(frameTime);
        }
        if (json.has("frame_width")) {
            if (!json.get("frame_width").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_width").isNumber()) {
                throw new JsonParseException("Property 'frame_width' must be an integer!");
            }
            int frameWidth = json.get("frame_width").getAsNumber().intValue();
            if (frameWidth <= 0) {
                throw new JsonParseException("Property 'frame_width' must have a value greater than 0!");
            }
            builder.frameWidth(frameWidth);
        }
        if (json.has("frame_height")) {
            if (!json.get("frame_height").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_height").isNumber()) {
                throw new JsonParseException("Property 'frame_height' must be an integer!");
            }
            int frameHeight = json.get("frame_height").getAsNumber().intValue();
            if (frameHeight <= 0) {
                throw new JsonParseException("Property 'frame_height' must have a value greater than 0!");
            }
            builder.frameHeight(frameHeight);
        }
        if (json.has("loop_type")) {
            ScrollingTextureData.LoopType loopType;
            if (!json.get("loop_type").isJsonPrimitive() || !json.getAsJsonPrimitive("loop_type").isString()) {
                throw new JsonParseException("Property 'loop_type' must be a string!");
            }
            String loopTypeString = json.get("loop_type").getAsString();
            try {
                loopType = ScrollingTextureData.LoopType.valueOf(loopTypeString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'loop_type' must be one of " + Arrays.toString((Object[])ScrollingTextureData.LoopType.values()).toLowerCase(Locale.ROOT) + ", not '" + loopTypeString + "'!");
            }
            builder.loopType(loopType);
        }
        if (json.has("loop_pause")) {
            if (!json.get("loop_pause").isJsonPrimitive() || !json.getAsJsonPrimitive("loop_pause").isNumber()) {
                throw new JsonParseException("Property 'loop_pause' must be an integer!");
            }
            int loopPause = json.get("loop_pause").getAsNumber().intValue();
            if (loopPause < 0) {
                throw new JsonParseException("Property 'loop_pause' must have a positive value!");
            }
            builder.loopPause(loopPause);
        }
        return (ScrollingTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(ScrollingTextureData data) {
        JsonObject json = new JsonObject();
        if (data.getStartPosition() != ScrollingTextureData.Position.TOP_LEFT) {
            json.addProperty("from", data.getStartPosition().name().toLowerCase(Locale.ROOT));
        }
        if (data.getEndPosition() != ScrollingTextureData.Position.BOTTOM_LEFT) {
            json.addProperty("to", data.getEndPosition().name().toLowerCase(Locale.ROOT));
        }
        if (data.getFrameTime() != 10) {
            json.addProperty("frame_time", (Number)data.getFrameTime());
        }
        if (data.getFrameWidth() != 16) {
            json.addProperty("frame_width", (Number)data.getFrameWidth());
        }
        if (data.getFrameHeight() != 16) {
            json.addProperty("frame_height", (Number)data.getFrameHeight());
        }
        if (data.getLoopType() != ScrollingTextureData.LoopType.RESET) {
            json.addProperty("loop_type", data.getLoopType().name().toLowerCase(Locale.ROOT));
        }
        if (data.getLoopPause() != 0) {
            json.addProperty("loop_pause", (Number)data.getLoopPause());
        }
        return json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, ScrollingTextureData data) {
        if (context.getTextureWidth() < data.getFrameWidth() || context.getTextureHeight() < data.getFrameHeight()) {
            throw new RuntimeException("Frame size must be smaller than the texture size!");
        }
        return Pair.of(data.getFrameWidth(), data.getFrameHeight());
    }

    @Override
    public TextureAtlasSprite createSprite(SpriteCreationContext context, ScrollingTextureData data) {
        float percentage;
        int index;
        boolean reverse = data.getLoopType() == ScrollingTextureData.LoopType.REVERSE;
        int startX = data.getStartPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getStartPosition() == ScrollingTextureData.Position.BOTTOM_LEFT ? 0 : context.getTextureWidth() - data.getFrameWidth();
        int startY = data.getStartPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getStartPosition() == ScrollingTextureData.Position.TOP_RIGHT ? 0 : context.getTextureHeight() - data.getFrameHeight();
        int endX = data.getEndPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getEndPosition() == ScrollingTextureData.Position.BOTTOM_LEFT ? 0 : context.getTextureWidth() - data.getFrameWidth();
        int endY = data.getEndPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getEndPosition() == ScrollingTextureData.Position.TOP_RIGHT ? 0 : context.getTextureHeight() - data.getFrameHeight();
        int stepCount = Math.max(Math.abs(endX - startX), Math.abs(endY - startY)) + 1;
        int frameCount = reverse ? Math.max((stepCount - 1) * 2, 1) : stepCount;
        int[] xPositions = new int[frameCount];
        int[] yPositions = new int[frameCount];
        int[] frameTimes = new int[frameCount];
        for (index = 0; index < stepCount; ++index) {
            percentage = stepCount > 1 ? (float)index / (float)(stepCount - 1) : 0.5f;
            xPositions[index] = Math.round((float)startX + (float)(endX - startX) * percentage);
            yPositions[index] = Math.round((float)startY + (float)(endY - startY) * percentage);
            frameTimes[index] = data.getFrameTime();
        }
        int n = stepCount - 1;
        frameTimes[n] = frameTimes[n] + data.getLoopPause();
        if (reverse) {
            for (index = 1; index < stepCount - 1; ++index) {
                percentage = 1.0f - (float)index / (float)(stepCount - 1);
                xPositions[index + stepCount - 1] = Math.round((float)startX + (float)(endX - startX) * percentage);
                yPositions[index + stepCount - 1] = Math.round((float)startY + (float)(endY - startY) * percentage);
                frameTimes[index + stepCount - 1] = data.getFrameTime();
            }
            frameTimes[0] = frameTimes[0] + data.getLoopPause();
        }
        ScrollingSpriteContents contents = new ScrollingSpriteContents(context.createOriginalSprite().contents(), xPositions, yPositions, frameTimes);
        return new BaseTextureSprite(context.getAtlasLocation(), contents, context.getAtlasWidth(), context.getAtlasHeight(), context.getSpritePositionX(), context.getSpritePositionY(), context.getSpritePadding(), data);
    }

    private static class ScrollingSpriteContents
    extends SpriteContents {
        private final int[] xPositions;
        private final int[] yPositions;
        private final List<SpriteContents.FrameInfo> frames;

        public ScrollingSpriteContents(SpriteContents original, int[] xPositions, int[] yPositions, int[] frameTimes) {
            super(original.name(), new FrameSize(original.width(), original.height()), original.originalImage);
            this.byMipLevel = original.byMipLevel;
            this.mipmapStrategy = original.mipmapStrategy;
            this.alphaCutoffBias = original.alphaCutoffBias;
            ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
            ArrayList<SpriteContents.FrameInfo> frames = new ArrayList<SpriteContents.FrameInfo>();
            for (int i = 0; i < frameTimes.length; ++i) {
                Pair<Integer, Integer> position = Pair.of(xPositions[i], yPositions[i]);
                int frameIndex = positions.indexOf(position);
                if (frameIndex == -1) {
                    frameIndex = positions.size();
                    positions.add(position);
                }
                frames.add(new SpriteContents.FrameInfo(frameIndex, frameTimes[i]));
            }
            this.xPositions = positions.stream().mapToInt(Pair::left).toArray();
            this.yPositions = positions.stream().mapToInt(Pair::right).toArray();
            this.frames = List.copyOf(frames);
            this.animatedTexture = new ScrollingAnimatedTexture();
        }

        public boolean isTransparent(int frame, int x, int y) {
            int index = this.frames.get(frame).index();
            return ARGB.alpha((int)this.originalImage.getPixel(this.xPositions[index] + x, this.yPositions[index] + y)) == 0;
        }

        private class ScrollingAnimatedTexture
        extends SpriteContents.AnimatedTexture {
            public ScrollingAnimatedTexture() {
                super((SpriteContents)ScrollingSpriteContents.this, ScrollingSpriteContents.this.frames, 1, false);
            }

            public SpriteContents.AnimationState createAnimationState(GpuBufferSlice bufferSlice, int offset) {
                GpuDevice gpuDevice = RenderSystem.getDevice();
                Int2ObjectOpenHashMap textureViews = new Int2ObjectOpenHashMap();
                GpuBufferSlice[] slices = new GpuBufferSlice[ScrollingSpriteContents.this.byMipLevel.length];
                for (int frameIndex : this.getUniqueFrames().toArray()) {
                    GpuTexture gpuTexture = gpuDevice.createTexture(() -> String.valueOf(ScrollingSpriteContents.this.name) + " animation frame " + frameIndex, 5, TextureFormat.RGBA8, ScrollingSpriteContents.this.width, ScrollingSpriteContents.this.height, 1, ScrollingSpriteContents.this.byMipLevel.length + 1);
                    int x = ScrollingSpriteContents.this.xPositions[frameIndex];
                    int y = ScrollingSpriteContents.this.yPositions[frameIndex];
                    for (int m = 0; m < ScrollingSpriteContents.this.byMipLevel.length; ++m) {
                        RenderSystem.getDevice().createCommandEncoder().writeToTexture(gpuTexture, ScrollingSpriteContents.this.byMipLevel[m], m, 0, 0, 0, ScrollingSpriteContents.this.width >> m, ScrollingSpriteContents.this.height >> m, x >> m, y >> m);
                    }
                    textureViews.put(frameIndex, (Object)RenderSystem.getDevice().createTextureView(gpuTexture));
                }
                for (int level = 0; level < ScrollingSpriteContents.this.byMipLevel.length; ++level) {
                    slices[level] = bufferSlice.slice((long)(level * offset), (long)offset);
                }
                return new SpriteContents.AnimationState((SpriteContents)ScrollingSpriteContents.this, (SpriteContents.AnimatedTexture)this, (Int2ObjectMap)textureViews, slices);
            }
        }
    }
}

