/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.PackExtension;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.TextAlignment;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix3x2fStack;

public class MinimumVersionWarningScreen
extends Screen {
    private static final Identifier FUSION_LOGO = Identifier.fromNamespaceAndPath((String)"fusion", (String)"textures/resourcepacks/fusion_icon.png");
    private final PackSelectionModel.EntryBase pack;
    private final Consumer<Boolean> confirmation;
    private final Component title;
    private final int titleWidth;
    private final FormattedCharSequence packName;
    private final MultiLineLabel packDescription;
    private final MultiLineLabel headerMessage;
    private final MultiLineLabel confirmationMessage;
    private final Component currentVersionLabel;
    private final Component requiredVersionLabel;
    private final Component currentVersion;
    private final Component requiredVersion;
    private final int versionLabelTextWidth;
    private final int versionTextWidth;
    private final Button confirmButton;
    private final Button cancelButton;

    public MinimumVersionWarningScreen(PackSelectionModel.EntryBase pack, Consumer<Boolean> confirmation) {
        super((Component)Component.translatable((String)"fusion.resource_packs.warning_screen.title"));
        this.pack = pack;
        this.confirmation = confirmation;
        Font font = Minecraft.getInstance().font;
        this.title = Component.translatable((String)"fusion.resource_packs.warning_screen.title").withStyle(ChatFormatting.UNDERLINE);
        this.titleWidth = font.width((FormattedText)this.title);
        int width = font.width((FormattedText)pack.getTitle());
        if (width > 157) {
            FormattedText croppedTitle = FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)pack.getTitle(), 157 - font.width("...")), FormattedText.of((String)"...")});
            this.packName = Language.getInstance().getVisualOrder(croppedTitle);
        } else {
            this.packName = pack.getTitle().getVisualOrderText();
        }
        this.packDescription = MultiLineLabel.create((Font)font, (int)157, (int)2, (Component[])new Component[]{pack.getExtendedDescription()});
        this.headerMessage = MultiLineLabel.create((Font)font, (Component)Component.translatable((String)"fusion.resource_packs.warning_screen.message"), (int)220);
        this.confirmationMessage = MultiLineLabel.create((Font)font, (Component)Component.translatable((String)"fusion.resource_packs.warning_screen.confirmation"), (int)220);
        this.currentVersionLabel = Component.translatable((String)"fusion.resource_packs.warning_screen.current_version");
        this.requiredVersionLabel = Component.translatable((String)"fusion.resource_packs.warning_screen.required_version");
        this.versionLabelTextWidth = Math.max(font.width((FormattedText)this.currentVersionLabel), font.width((FormattedText)this.requiredVersionLabel));
        this.currentVersion = Component.literal((String)FusionClient.getFusionVersion()).withStyle(ChatFormatting.GOLD);
        this.requiredVersion = Component.literal((String)((PackExtension)pack.pack).getFusionMetadata().getMinimumVersion()).withStyle(ChatFormatting.GOLD);
        this.versionTextWidth = Math.max(font.width((FormattedText)this.currentVersion), font.width((FormattedText)this.requiredVersion));
        this.confirmButton = Button.builder((Component)Component.translatable((String)"fusion.resource_packs.warning_screen.confirm"), b -> confirmation.accept(true)).width(80).build();
        this.cancelButton = Button.builder((Component)Component.translatable((String)"fusion.resource_packs.warning_screen.cancel"), b -> confirmation.accept(false)).width(80).build();
    }

    public Component getNarrationMessage() {
        return Component.translatable((String)"fusion.resource_packs.warning_screen.message").append((Component)Component.translatable((String)"fusion.resource_packs.warning_screen.confirmation"));
    }

    protected void init() {
        super.init();
        this.confirmButton.setPosition(this.width / 2 - this.confirmButton.getWidth() - 2, this.height / 2 + 110 - this.confirmButton.getHeight());
        this.cancelButton.setPosition(this.width / 2 + 2, this.height / 2 + 110 - this.cancelButton.getHeight());
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
    }

    public void render(final GuiGraphics graphics, final int mouseX, final int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate((float)this.width / 2.0f, (float)this.height / 2.0f - 110.0f);
        int titleLeft = -(this.titleWidth + 17) / 2;
        graphics.blit(FUSION_LOGO, titleLeft, 0, 0, 0, 12.0f, 12.0f, 12.0f, 12.0f);
        graphics.drawString(this.font, this.title, titleLeft + 17, 2, -1);
        poseStack.popMatrix();
        poseStack.pushMatrix();
        int middleHeight = 98 + this.headerMessage.getLineCount() * 10 + this.confirmationMessage.getLineCount() * 10;
        poseStack.translate((float)this.width / 2.0f, (float)(this.height - middleHeight) / 2.0f);
        graphics.fill(-98, 0, 98, 36, ARGB.color((int)70, (int)255, (int)255, (int)255));
        graphics.blit(RenderPipelines.GUI_TEXTURED, this.pack.getIconTexture(), -96, 2, 0.0f, 0.0f, 32, 32, 32, 32);
        graphics.drawString(this.font, this.packName, -62, 3, ARGB.color((int)255, (int)0xFFFFFF));
        final ActiveTextCollector dummyTextCollector = graphics.textRenderer();
        this.packDescription.visitLines(TextAlignment.LEFT, -62, 14, 10, new ActiveTextCollector(){

            public ActiveTextCollector.Parameters defaultParameters() {
                return dummyTextCollector.defaultParameters();
            }

            public void defaultParameters(ActiveTextCollector.Parameters parameters) {
                dummyTextCollector.defaultParameters(parameters);
            }

            public void accept(TextAlignment alignment, int x, int y, ActiveTextCollector.Parameters parameters, FormattedCharSequence text) {
                int left = alignment.calculateLeft(x, Minecraft.getInstance().font, text);
                GuiTextRenderState textRenderState = new GuiTextRenderState(Minecraft.getInstance().font, text, parameters.pose(), left, y, ARGB.color((float)parameters.opacity(), (int)-8355712), 0, true, true, parameters.scissor());
                if (ARGB.as8BitChannel((float)parameters.opacity()) != 0) {
                    graphics.guiRenderState.submitText(textRenderState);
                }
                ActiveTextCollector.findElementUnderCursor((GuiTextRenderState)textRenderState, (float)mouseX, (float)mouseY, s -> {});
            }

            public void acceptScrolling(Component component, int i, int j, int k, int l, int m, ActiveTextCollector.Parameters parameters) {
                dummyTextCollector.acceptScrolling(component, i, j, k, l, m, parameters);
            }
        });
        graphics.hLine(-115, 115, 44, ARGB.color((int)255, (int)255, (int)255));
        int textLeft = -Math.max(this.headerMessage.getWidth(), this.confirmationMessage.getWidth()) / 2;
        this.headerMessage.visitLines(TextAlignment.LEFT, textLeft, 54, 10, graphics.textRenderer());
        int textHeight = this.headerMessage.getLineCount() * 10;
        this.confirmationMessage.visitLines(TextAlignment.LEFT, textLeft, 58 + textHeight, 10, graphics.textRenderer());
        graphics.hLine(-115, 115, 66 + (textHeight += this.confirmationMessage.getLineCount() * 10), ARGB.color((int)255, (int)255, (int)255));
        textLeft = -(this.versionLabelTextWidth + 5 + this.versionTextWidth) / 2;
        graphics.drawString(this.font, this.currentVersionLabel, textLeft, 76 + textHeight, ARGB.color((int)180, (int)180, (int)180));
        graphics.drawString(this.font, this.requiredVersionLabel, textLeft, 88 + textHeight, ARGB.color((int)180, (int)180, (int)180));
        graphics.drawString(this.font, this.currentVersion, textLeft + this.versionLabelTextWidth + 5, 76 + textHeight, ARGB.color((int)255, (int)0xFFFFFF));
        graphics.drawString(this.font, this.requiredVersion, textLeft + this.versionLabelTextWidth + 5, 88 + textHeight, ARGB.color((int)255, (int)0xFFFFFF));
        poseStack.popMatrix();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isEscape()) {
            this.confirmation.accept(false);
            return true;
        }
        return super.keyPressed(keyEvent);
    }
}

