/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.vanilla;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;

public class VanillaModelSerializer
implements JsonSerializer<BlockModel> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new VanillaModelSerializer()).disableHtmlEscaping().setPrettyPrinting().create();

    private VanillaModelSerializer() {
    }

    public JsonElement serialize(BlockModel src, Type typeOfSrc, JsonSerializationContext context) {
        UnbakedModel.GuiLight guiLight;
        JsonObject json = new JsonObject();
        Identifier parent = src.parent();
        if (parent != null) {
            json.addProperty("parent", parent.toString());
        }
        if (!src.textureSlots().values().isEmpty()) {
            JsonObject textures = new JsonObject();
            src.textureSlots().values().forEach((key, texture) -> textures.addProperty(key, (String)(texture instanceof TextureSlots.Value ? ((TextureSlots.Value)texture).material().texture().toString() : "#" + ((TextureSlots.Reference)texture).target())));
            json.add("textures", (JsonElement)textures);
        }
        if (src.ambientOcclusion() != null) {
            json.addProperty("ambientocclusion", src.ambientOcclusion());
        }
        if ((guiLight = src.guiLight()) != null) {
            json.addProperty("gui_light", guiLight.name().toLowerCase(Locale.ROOT));
        }
        return json;
    }
}

