/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.BlockModelBakingContext;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelElement;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;

public class ConnectingModelDataImpl
extends BaseModelDataImpl
implements ConnectingModelData {
    private final Map<String, ConnectionPredicate> predicates;
    private final Map<String, String> connectionReferences;

    public ConnectingModelDataImpl(BlockModel model, List<Identifier> parents, List<ConnectingModelElement> elements, Map<String, ConnectionPredicate> predicates, Map<String, String> references) {
        super(model, parents, elements);
        this.predicates = ImmutableMap.copyOf(predicates);
        this.connectionReferences = ImmutableMap.copyOf(references);
    }

    public List<ConnectingModelElement> getElements() {
        return super.getElements();
    }

    @Override
    public ConnectionPredicate getConnectionPredicate(String texture) {
        return this.predicates.get(texture);
    }

    @Override
    public ConnectionPredicate getDefaultConnectionPredicate() {
        return this.getConnectionPredicate("default");
    }

    @Override
    public Map<String, ConnectionPredicate> getAllConnectionPredicates() {
        return this.predicates;
    }

    public Map<String, String> getConnectionReferences() {
        return this.connectionReferences;
    }

    @Override
    public List<BaseModelQuad> bakeQuads(BlockModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.CONNECTING, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(BlockModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        UnbakedGeometry unbakedGeometry;
        List elements;
        modelStack.addLast(model);
        if (!(model.getModelType() != DefaultModelTypes.BASE && model.getModelType() != DefaultModelTypes.CONNECTING || (elements = ((BaseModelDataImpl)model.getModelData()).getElements()) == null || elements.isEmpty())) {
            for (BaseModelElement element : elements) {
                for (Direction direction : element.original.faces().keySet()) {
                    BlockElementFace face = (BlockElementFace)element.original.faces().get(direction);
                    TextureAtlasSprite sprite = context.getTexture(this.resolveMaterial(context, modelStack, face.texture()));
                    BakedQuad quad = FaceBakery.bakeQuad((ModelBaker.PartCache)context.getModelBaker().parts(), (Vector3fc)element.original.from(), (Vector3fc)element.original.to(), (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)context.getTransformation(), (BlockElementRotation)element.original.rotation(), (boolean)element.original.shade(), (int)element.original.lightEmission());
                    Direction cullDirection = face.cullForDirection() != null ? Direction.rotate((Matrix4fc)context.getTransformation().transformation().getMatrix(), (Direction)face.cullForDirection()) : null;
                    String connectionsKey = element instanceof ConnectingModelElement && ((ConnectingModelElement)element).faceConnectionKeys.containsKey(direction) ? ((ConnectingModelElement)element).faceConnectionKeys.get(direction) : face.texture();
                    ConnectionPredicate predicate = this.resolveConnectionKey(context, modelStack, connectionsKey);
                    output.accept(new ConnectingModelQuad(quad, cullDirection, predicate));
                }
            }
            modelStack.pop();
            return;
        }
        elements = null;
        UnbakedModel vanillaModel = model.getAsVanillaModel();
        if (vanillaModel instanceof ItemModelGenerator) {
            elements = this.generateItemModel(context, modelStack);
        } else if (vanillaModel != null && (unbakedGeometry = vanillaModel.geometry()) instanceof SimpleUnbakedGeometry) {
            SimpleUnbakedGeometry geometry = (SimpleUnbakedGeometry)unbakedGeometry;
            elements = geometry.elements();
        }
        if (elements != null && !elements.isEmpty()) {
            for (BlockElement element : elements) {
                for (Direction direction : element.faces().keySet()) {
                    BlockElementFace face = (BlockElementFace)element.faces().get(direction);
                    TextureAtlasSprite sprite = context.getTexture(this.resolveMaterial(context, modelStack, face.texture()));
                    BakedQuad quad = FaceBakery.bakeQuad((ModelBaker.PartCache)context.getModelBaker().parts(), (Vector3fc)element.from(), (Vector3fc)element.to(), (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)context.getTransformation(), (BlockElementRotation)element.rotation(), (boolean)element.shade(), (int)element.lightEmission());
                    Direction cullDirection = face.cullForDirection() != null ? Direction.rotate((Matrix4fc)context.getTransformation().transformation().getMatrix(), (Direction)face.cullForDirection()) : null;
                    String connectionsKey = face.texture();
                    ConnectionPredicate predicate = this.resolveConnectionKey(context, modelStack, connectionsKey);
                    output.accept(new ConnectingModelQuad(quad, cullDirection, predicate));
                }
            }
            modelStack.pop();
            return;
        }
        for (Identifier location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    private ConnectionPredicate resolveConnectionKey(BlockModelBakingContext context, Deque<ModelInstance<?>> modelStack, String key) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            String newKey = null;
            for (ModelInstance<?> model : modelStack) {
                if (model.getModelType() != DefaultModelTypes.CONNECTING) continue;
                ConnectionPredicate predicate = ((ConnectingModelDataImpl)model.getModelData()).predicates.get(currentKey);
                if (predicate != null) {
                    return predicate;
                }
                String reference = ((ConnectingModelDataImpl)model.getModelData()).connectionReferences.get(currentKey);
                if (reference == null) continue;
                newKey = reference;
                break;
            }
            if (newKey == null) {
                for (ModelInstance<?> model : modelStack) {
                    TextureSlots.SlotContents material;
                    UnbakedModel vanillaModel = model.getAsVanillaModel();
                    if (vanillaModel == null || (material = (TextureSlots.SlotContents)vanillaModel.textureSlots().values().get(currentKey)) == null) continue;
                    newKey = material instanceof TextureSlots.Value ? ((TextureSlots.Value)material).material().texture().toString() : ((TextureSlots.Reference)material).target();
                    break;
                }
            }
            if (newKey == null) {
                Either<ConnectionPredicate, String> entry = ConnectingModelDataImpl.findConnectionsEntry(context, modelStack.getLast(), currentKey);
                if (entry != null && entry.isLeft()) {
                    return entry.left();
                }
                if (entry != null && entry.isRight()) {
                    newKey = entry.right();
                }
            }
            if (newKey == null && !currentKey.equals("default")) {
                newKey = "default";
            }
            if (newKey == null) {
                return null;
            }
            currentKey = newKey;
            if (currentKey.charAt(0) == '#') {
                currentKey = currentKey.substring(1);
            }
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve connections due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return null;
            }
            encounteredKeys.add(currentKey);
        }
    }

    private static Either<ConnectionPredicate, String> findConnectionsEntry(BlockModelBakingContext context, ModelInstance<?> model, String key) {
        if (model.getModelType() == DefaultModelTypes.CONNECTING) {
            ConnectionPredicate predicate = ((ConnectingModelDataImpl)model.getModelData()).predicates.get(key);
            if (predicate != null) {
                return Either.left(predicate);
            }
            String reference = ((ConnectingModelDataImpl)model.getModelData()).connectionReferences.get(key);
            if (reference != null) {
                return Either.right(reference);
            }
        }
        for (Identifier location : model.getParentModels()) {
            Either<ConnectionPredicate, String> entry;
            ModelInstance<?> parent = context.getModel(location);
            if (parent == null || (entry = ConnectingModelDataImpl.findConnectionsEntry(context, parent, key)) == null) continue;
            return entry;
        }
        return null;
    }
}

