/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.block.PaneCullingBakedModel;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockModelModifierReloadListener {
    private static final String LOCATION = "fusion/model_modifiers/blocks";
    private static final FileToIdConverter ID_CONVERTER = FileToIdConverter.json((String)"fusion/model_modifiers/blocks");
    public static final BlockModelModifierReloadListener INSTANCE = new BlockModelModifierReloadListener();
    private final Map<BlockState, Properties> models = new HashMap<BlockState, Properties>();

    private BlockModelModifierReloadListener() {
    }

    public void registerOverlays(ResolvableModel.Resolver resolver) {
        HashSet<Identifier> models = new HashSet<Identifier>();
        for (Properties properties : this.models.values()) {
            models.addAll(properties.appendModels);
        }
        models.forEach(arg_0 -> ((ResolvableModel.Resolver)resolver).markDependency(arg_0));
    }

    public void applyOverlays(ModelBakery.BakingResult results, ModelBakery.ModelBakerImpl resolver) {
        Map bakedModels = results.blockStateModels();
        for (Map.Entry<BlockState, Properties> entry : this.models.entrySet()) {
            BlockState target = entry.getKey();
            BlockStateModel targetModel = (BlockStateModel)bakedModels.get(target);
            if (targetModel == null) continue;
            Properties properties = entry.getValue();
            List<Identifier> overlays = properties.appendModels;
            List<BlockStateModel> overlayModels = overlays.stream().map(l -> new SingleVariant.Unbaked(new Variant(l, Variant.SimpleModelState.DEFAULT)).bake((ModelBaker)resolver)).toList();
            Object model = new BlockModelModifierBakedModel(targetModel, overlayModels, properties.showBreakingOverlay);
            if (properties.paneCullingFix) {
                model = new PaneCullingBakedModel((BlockStateModel)model);
            }
            bakedModels.put(target, model);
        }
    }

    public void reload(ResourceManager resourceManager) {
        this.models.clear();
        HashMap resources = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)resourceManager, (FileToIdConverter)ID_CONVERTER, (DynamicOps)JsonOps.INSTANCE, (Codec)new Codec<JsonElement>(this){

            public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of((Object)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
            }

            public <T> DataResult<T> encode(JsonElement input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, input));
            }
        }, resources);
        for (Map.Entry entry : resources.entrySet()) {
            Identifier location = (Identifier)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Block model overlay '" + String.valueOf(location) + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse block model overlay '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Model overlay must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet targets = new HashSet();
        for (JsonElement element : targetsJson) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                Identifier identifier = Identifier.parse((String)element.getAsString());
                Optional block = BuiltInRegistries.BLOCK.getOptional(identifier);
                if (block.isEmpty()) {
                    throw new JsonParseException("Could not find a block for model overlay target '" + String.valueOf(identifier) + "'!");
                }
                targets.addAll(((Block)block.get()).getStateDefinition().getPossibleStates());
                continue;
            }
            if (element.isJsonObject()) {
                this.parseTarget(element.getAsJsonObject()).forEach(targets::add);
                continue;
            }
            throw new JsonParseException("Model overlay 'targets' array must only contain objects and strings!");
        }
        if (targets.isEmpty()) {
            return;
        }
        if (!json.has("append") && !json.has("pane_culling_fix")) {
            throw new JsonParseException("Must have either 'append' or 'pane_culling_fix' property!");
        }
        LinkedHashSet<Identifier> models = new LinkedHashSet<Identifier>();
        if (json.has("append")) {
            if (!json.get("append").isJsonArray()) {
                throw new JsonParseException("Property 'append' must be an array!");
            }
            JsonArray appendJson = json.getAsJsonArray("append");
            for (JsonElement element : appendJson) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'append' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Model must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                models.add(Identifier.parse((String)element.getAsString()));
            }
        }
        Boolean showBreakingOverlay = null;
        if (json.has("show_breaking_overlay")) {
            if (!json.get("show_breaking_overlay").isJsonPrimitive() || !json.get("show_breaking_overlay").getAsJsonPrimitive().isBoolean()) {
                throw new JsonParseException("Property 'show_breaking_overlay' must be a boolean!");
            }
            showBreakingOverlay = json.get("show_breaking_overlay").getAsBoolean();
        }
        Boolean paneCullingFix = null;
        if (json.has("pane_culling_fix")) {
            if (!json.get("pane_culling_fix").isJsonPrimitive() || !json.getAsJsonPrimitive("pane_culling_fix").isBoolean()) {
                throw new JsonParseException("Property 'pane_culling_fix' must be a boolean!");
            }
            paneCullingFix = json.get("pane_culling_fix").getAsBoolean();
        }
        if (models.isEmpty() && paneCullingFix != Boolean.TRUE) {
            return;
        }
        for (BlockState target : targets) {
            Properties properties = this.models.computeIfAbsent(target, t -> new Properties());
            properties.appendModels.addAll(models);
            if (showBreakingOverlay != null) {
                properties.showBreakingOverlay = showBreakingOverlay;
            }
            if (paneCullingFix == null) continue;
            properties.paneCullingFix = paneCullingFix;
        }
    }

    private Stream<BlockState> parseTarget(JsonObject json) {
        if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
            throw new JsonParseException("Target must have string property 'block'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
            throw new JsonParseException("Target property 'block' must be a valid identifier, not '" + json.get("block").getAsString() + "'!!");
        }
        Identifier identifier = Identifier.parse((String)json.get("block").getAsString());
        Optional optional = BuiltInRegistries.BLOCK.getOptional(identifier);
        if (optional.isEmpty()) {
            throw new JsonParseException("Could not find a block for model overlay target '" + String.valueOf(identifier) + "'!");
        }
        Block block = (Block)optional.get();
        HashMap<Property, ImmutableSet> properties = new HashMap<Property, ImmutableSet>();
        if (!json.has("properties") || !json.get("properties").isJsonObject()) {
            throw new JsonParseException("Match block predicate must have object property 'properties'!");
        }
        if (json.getAsJsonObject("properties").isEmpty()) {
            throw new JsonParseException("At least one property must be specified for match state predicate!");
        }
        for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
            Property property = block.getStateDefinition().getProperty((String)entry.getKey());
            if (property == null) {
                throw new JsonParseException("Block '" + String.valueOf(identifier) + "' does not have a property named '" + (String)entry.getKey() + "'!");
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                Optional value = property.getValue(((JsonElement)entry.getValue()).getAsString());
                if (value.isEmpty()) {
                    throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.getName() + "' in block '" + String.valueOf(identifier) + "'!");
                }
                builder.add(value.get());
            } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                if (((JsonElement)entry.getValue()).getAsJsonArray().isEmpty()) {
                    throw new JsonParseException("Valid values for property '" + property.getName() + "' cannot be empty!");
                }
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                    }
                    Optional value = property.getValue(element.getAsString());
                    if (value.isEmpty()) {
                        throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.getName() + "' in block '" + String.valueOf(identifier) + "'!");
                    }
                    builder.add(value.get());
                }
            } else {
                throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
            }
            properties.put(property, builder.build());
        }
        Stream<Object> states = Stream.of((BlockState)block.getStateDefinition().any());
        for (Property property : block.getStateDefinition().getProperties()) {
            if (properties.containsKey(property)) {
                Set values = (Set)properties.get(property);
                states = states.flatMap(state -> values.stream().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value)));
                continue;
            }
            states = states.flatMap(state -> property.getAllValues().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value.value())));
        }
        return states;
    }

    private static <T extends Comparable<T>> BlockState stateWithValue(BlockState state, Property<?> property, Object value) {
        return (BlockState)state.setValue(property, (Comparable)value);
    }

    private static class Properties {
        final List<Identifier> appendModels = new ArrayList<Identifier>();
        boolean paneCullingFix;
        boolean showBreakingOverlay = true;

        private Properties() {
        }
    }
}

