/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.util.TextureAtlases;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.Identifier;

public class SpriteIdentifierImpl
implements SpriteIdentifier {
    public static final SpriteIdentifier MISSING = SpriteIdentifierImpl.of(TextureAtlases.getBlocks(), MissingTextureAtlasSprite.getLocation());
    private final Identifier atlas;
    private final Identifier texture;
    private Material material;

    public static SpriteIdentifier of(Identifier atlas, Identifier texture) {
        return new SpriteIdentifierImpl(atlas, texture);
    }

    public static SpriteIdentifier of(Material material) {
        return new SpriteIdentifierImpl(material);
    }

    private SpriteIdentifierImpl(Identifier atlas, Identifier texture) {
        this.atlas = atlas;
        this.texture = texture;
    }

    private SpriteIdentifierImpl(Material material) {
        this(material.atlasLocation(), material.texture());
        this.material = material;
    }

    @Override
    public Identifier getAtlas() {
        return this.atlas;
    }

    @Override
    public Identifier getTexture() {
        return this.texture;
    }

    @Override
    public Material toMaterial() {
        return this.material == null ? (this.material = SpriteIdentifier.super.toMaterial()) : this.material;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof SpriteIdentifierImpl)) {
            return false;
        }
        SpriteIdentifierImpl that = (SpriteIdentifierImpl)o;
        return this.atlas.equals((Object)that.atlas) && this.texture.equals((Object)that.texture);
    }

    public int hashCode() {
        int result = this.atlas.hashCode();
        result = 31 * result + this.texture.hashCode();
        return result;
    }
}

