/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.Identifier;

public class ModelTypeRegistryImpl {
    private static final Map<Identifier, ModelType<?>> IDENTIFIER_TO_MODEL_TYPE = new HashMap();
    private static final Map<ModelType<?>, Identifier> MODEL_TYPE_TO_IDENTIFIER = new HashMap();
    private static boolean finalized = false;

    public static synchronized void registerModelType(Identifier identifier, ModelType<?> modelType) {
        if (finalized) {
            throw new RuntimeException("Model types must be registered before models get loaded!");
        }
        if (IDENTIFIER_TO_MODEL_TYPE.containsKey(identifier)) {
            throw new RuntimeException("Duplicate model type registration for identifier '" + String.valueOf(identifier) + "'!");
        }
        if (MODEL_TYPE_TO_IDENTIFIER.containsKey(modelType)) {
            throw new RuntimeException("Model type has already been registered!");
        }
        IDENTIFIER_TO_MODEL_TYPE.put(identifier, modelType);
        MODEL_TYPE_TO_IDENTIFIER.put(modelType, identifier);
    }

    public static JsonObject serializeModelData(ModelInstance<?> model) {
        JsonObject json;
        if (!finalized) {
            throw new RuntimeException("Can only serialize model data after registration has completed!");
        }
        Identifier identifier = MODEL_TYPE_TO_IDENTIFIER.get(model.getModelType());
        if (identifier == null) {
            throw new RuntimeException("Cannot use unregistered model type '" + String.valueOf(model.getModelType()) + "'!");
        }
        try {
            json = model.getModelType().serialize(model.getModelData());
            if (json == null) {
                json = new JsonObject();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst serializing data for model type '" + String.valueOf(identifier) + "'!", e);
        }
        json.addProperty("loader", "fusion:model");
        json.addProperty("type", identifier.toString());
        return json;
    }

    public static ModelInstance<?> deserializeModelData(JsonObject json) {
        Object modelData;
        if (!finalized) {
            throw new RuntimeException("Can only deserialize model data after registration has completed!");
        }
        ModelType<BaseModelData> modelType = DefaultModelTypes.BASE;
        Identifier identifier = ModelTypeRegistryImpl.getIdentifier(modelType);
        if (json.has("type")) {
            JsonElement typeJson = json.getAsJsonObject().get("type");
            if (typeJson == null || !typeJson.isJsonPrimitive() || !typeJson.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Fusion model must have string property 'type'!");
            }
            if (!IdentifierUtil.isValidIdentifier(typeJson.getAsString())) {
                throw new JsonParseException("Property 'type' must be a valid identifier!");
            }
            identifier = IdentifierUtil.withFusionNamespace(typeJson.getAsString());
            modelType = IDENTIFIER_TO_MODEL_TYPE.get(identifier);
            if (modelType == null) {
                throw new JsonParseException("Unknown model type '" + String.valueOf(identifier) + "'!");
            }
        }
        JsonElement loaderJson = json.remove("loader");
        try {
            modelData = modelType.deserialize(json);
        }
        catch (JsonParseException e) {
            throw new JsonParseException("Invalid json for model type '" + String.valueOf(identifier) + "'!", (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst deserializing data for model type '" + String.valueOf(identifier) + "'!", e);
        }
        finally {
            if (loaderJson != null) {
                json.add("loader", loaderJson);
            }
        }
        return ModelInstance.of(modelType, modelData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Identifier getIdentifier(ModelType<?> modelType) {
        if (!finalized) {
            Class<ModelTypeRegistryImpl> clazz = ModelTypeRegistryImpl.class;
            synchronized (ModelTypeRegistryImpl.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return MODEL_TYPE_TO_IDENTIFIER.get(modelType);
            }
        }
        return MODEL_TYPE_TO_IDENTIFIER.get(modelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void finalizeRegistration() {
        if (finalized) return;
        Class<ModelTypeRegistryImpl> clazz = ModelTypeRegistryImpl.class;
        synchronized (ModelTypeRegistryImpl.class) {
            finalized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

